<?php

namespace MoniBounce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchInfo
 * @subpackage Structs
 */
class SearchInfo extends AbstractStructBase
{
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Zip;
    /**
     * The Phone1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Phone1;
    /**
     * The Phone2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone2;
    /**
     * The ApplicationName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ApplicationName;
    /**
     * The ProcessName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProcessName;
    /**
     * The DealerNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DealerNumber;
    /**
     * The DealerName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DealerName;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The CurrentSiteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentSiteID;
    /**
     * Constructor method for SearchInfo
     * @uses SearchInfo::setAddress1()
     * @uses SearchInfo::setAddress2()
     * @uses SearchInfo::setCity()
     * @uses SearchInfo::setState()
     * @uses SearchInfo::setZip()
     * @uses SearchInfo::setPhone1()
     * @uses SearchInfo::setPhone2()
     * @uses SearchInfo::setApplicationName()
     * @uses SearchInfo::setProcessName()
     * @uses SearchInfo::setDealerNumber()
     * @uses SearchInfo::setDealerName()
     * @uses SearchInfo::setFirstName()
     * @uses SearchInfo::setLastName()
     * @uses SearchInfo::setCurrentSiteID()
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $phone1
     * @param string $phone2
     * @param string $applicationName
     * @param string $processName
     * @param string $dealerNumber
     * @param string $dealerName
     * @param string $firstName
     * @param string $lastName
     * @param int $currentSiteID
     */
    public function __construct($address1 = null, $address2 = null, $city = null, $state = null, $zip = null, $phone1 = null, $phone2 = null, $applicationName = null, $processName = null, $dealerNumber = null, $dealerName = null, $firstName = null, $lastName = null, $currentSiteID = null)
    {
        $this
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setPhone1($phone1)
            ->setPhone2($phone2)
            ->setApplicationName($applicationName)
            ->setProcessName($processName)
            ->setDealerNumber($dealerNumber)
            ->setDealerName($dealerName)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCurrentSiteID($currentSiteID);
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress2()
    {
        return isset($this->Address2) ? $this->Address2 : null;
    }
    /**
     * Set Address2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address2
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        if (is_null($address2) || (is_array($address2) && empty($address2))) {
            unset($this->Address2);
        } else {
            $this->Address2 = $address2;
        }
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Phone1 value
     * @return string|null
     */
    public function getPhone1()
    {
        return $this->Phone1;
    }
    /**
     * Set Phone1 value
     * @param string $phone1
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone1)), __LINE__);
        }
        $this->Phone1 = $phone1;
        return $this;
    }
    /**
     * Get Phone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone2()
    {
        return isset($this->Phone2) ? $this->Phone2 : null;
    }
    /**
     * Set Phone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone2
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone2)), __LINE__);
        }
        if (is_null($phone2) || (is_array($phone2) && empty($phone2))) {
            unset($this->Phone2);
        } else {
            $this->Phone2 = $phone2;
        }
        return $this;
    }
    /**
     * Get ApplicationName value
     * @return string|null
     */
    public function getApplicationName()
    {
        return $this->ApplicationName;
    }
    /**
     * Set ApplicationName value
     * @param string $applicationName
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationName)), __LINE__);
        }
        $this->ApplicationName = $applicationName;
        return $this;
    }
    /**
     * Get ProcessName value
     * @return string|null
     */
    public function getProcessName()
    {
        return $this->ProcessName;
    }
    /**
     * Set ProcessName value
     * @param string $processName
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setProcessName($processName = null)
    {
        // validation for constraint: string
        if (!is_null($processName) && !is_string($processName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processName)), __LINE__);
        }
        $this->ProcessName = $processName;
        return $this;
    }
    /**
     * Get DealerNumber value
     * @return string|null
     */
    public function getDealerNumber()
    {
        return $this->DealerNumber;
    }
    /**
     * Set DealerNumber value
     * @param string $dealerNumber
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setDealerNumber($dealerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dealerNumber) && !is_string($dealerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerNumber)), __LINE__);
        }
        $this->DealerNumber = $dealerNumber;
        return $this;
    }
    /**
     * Get DealerName value
     * @return string|null
     */
    public function getDealerName()
    {
        return $this->DealerName;
    }
    /**
     * Set DealerName value
     * @param string $dealerName
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setDealerName($dealerName = null)
    {
        // validation for constraint: string
        if (!is_null($dealerName) && !is_string($dealerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerName)), __LINE__);
        }
        $this->DealerName = $dealerName;
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get CurrentSiteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentSiteID()
    {
        return isset($this->CurrentSiteID) ? $this->CurrentSiteID : null;
    }
    /**
     * Set CurrentSiteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentSiteID
     * @return \MoniBounce\StructType\SearchInfo
     */
    public function setCurrentSiteID($currentSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($currentSiteID) && !is_numeric($currentSiteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentSiteID)), __LINE__);
        }
        if (is_null($currentSiteID) || (is_array($currentSiteID) && empty($currentSiteID))) {
            unset($this->CurrentSiteID);
        } else {
            $this->CurrentSiteID = $currentSiteID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniBounce\StructType\SearchInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
