<?php

namespace MoniBounce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MatchResult
 * @subpackage Structs
 */
class MatchResult extends AbstractStructBase
{
    /**
     * The MatchID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MatchID;
    /**
     * The MatchCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MatchCode;
    /**
     * The SourceSystemID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SourceSystemID;
    /**
     * The SourceSiteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SourceSiteID;
    /**
     * Constructor method for MatchResult
     * @uses MatchResult::setMatchID()
     * @uses MatchResult::setMatchCode()
     * @uses MatchResult::setSourceSystemID()
     * @uses MatchResult::setSourceSiteID()
     * @param int $matchID
     * @param int $matchCode
     * @param int $sourceSystemID
     * @param int $sourceSiteID
     */
    public function __construct($matchID = null, $matchCode = null, $sourceSystemID = null, $sourceSiteID = null)
    {
        $this
            ->setMatchID($matchID)
            ->setMatchCode($matchCode)
            ->setSourceSystemID($sourceSystemID)
            ->setSourceSiteID($sourceSiteID);
    }
    /**
     * Get MatchID value
     * @return int|null
     */
    public function getMatchID()
    {
        return $this->MatchID;
    }
    /**
     * Set MatchID value
     * @param int $matchID
     * @return \MoniBounce\StructType\MatchResult
     */
    public function setMatchID($matchID = null)
    {
        // validation for constraint: int
        if (!is_null($matchID) && !is_numeric($matchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($matchID)), __LINE__);
        }
        $this->MatchID = $matchID;
        return $this;
    }
    /**
     * Get MatchCode value
     * @return int|null
     */
    public function getMatchCode()
    {
        return $this->MatchCode;
    }
    /**
     * Set MatchCode value
     * @param int $matchCode
     * @return \MoniBounce\StructType\MatchResult
     */
    public function setMatchCode($matchCode = null)
    {
        // validation for constraint: int
        if (!is_null($matchCode) && !is_numeric($matchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($matchCode)), __LINE__);
        }
        $this->MatchCode = $matchCode;
        return $this;
    }
    /**
     * Get SourceSystemID value
     * @return int|null
     */
    public function getSourceSystemID()
    {
        return $this->SourceSystemID;
    }
    /**
     * Set SourceSystemID value
     * @param int $sourceSystemID
     * @return \MoniBounce\StructType\MatchResult
     */
    public function setSourceSystemID($sourceSystemID = null)
    {
        // validation for constraint: int
        if (!is_null($sourceSystemID) && !is_numeric($sourceSystemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceSystemID)), __LINE__);
        }
        $this->SourceSystemID = $sourceSystemID;
        return $this;
    }
    /**
     * Get SourceSiteID value
     * @return int|null
     */
    public function getSourceSiteID()
    {
        return $this->SourceSiteID;
    }
    /**
     * Set SourceSiteID value
     * @param int $sourceSiteID
     * @return \MoniBounce\StructType\MatchResult
     */
    public function setSourceSiteID($sourceSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($sourceSiteID) && !is_numeric($sourceSiteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceSiteID)), __LINE__);
        }
        $this->SourceSiteID = $sourceSiteID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniBounce\StructType\MatchResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
