<?php

namespace MoniBounce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MatchResponse
 * @subpackage Structs
 */
class MatchResponse extends AbstractStructBase
{
    /**
     * The MatchID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MatchID;
    /**
     * The ResponseSeqNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResponseSeqNo;
    /**
     * The Outcome
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Outcome;
    /**
     * The MatchResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \MoniBounce\StructType\MatchResult
     */
    public $MatchResult;
    /**
     * Constructor method for MatchResponse
     * @uses MatchResponse::setMatchID()
     * @uses MatchResponse::setResponseSeqNo()
     * @uses MatchResponse::setOutcome()
     * @uses MatchResponse::setMatchResult()
     * @param int $matchID
     * @param int $responseSeqNo
     * @param bool $outcome
     * @param \MoniBounce\StructType\MatchResult $matchResult
     */
    public function __construct($matchID = null, $responseSeqNo = null, $outcome = null, \MoniBounce\StructType\MatchResult $matchResult = null)
    {
        $this
            ->setMatchID($matchID)
            ->setResponseSeqNo($responseSeqNo)
            ->setOutcome($outcome)
            ->setMatchResult($matchResult);
    }
    /**
     * Get MatchID value
     * @return int|null
     */
    public function getMatchID()
    {
        return $this->MatchID;
    }
    /**
     * Set MatchID value
     * @param int $matchID
     * @return \MoniBounce\StructType\MatchResponse
     */
    public function setMatchID($matchID = null)
    {
        // validation for constraint: int
        if (!is_null($matchID) && !is_numeric($matchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($matchID)), __LINE__);
        }
        $this->MatchID = $matchID;
        return $this;
    }
    /**
     * Get ResponseSeqNo value
     * @return int|null
     */
    public function getResponseSeqNo()
    {
        return $this->ResponseSeqNo;
    }
    /**
     * Set ResponseSeqNo value
     * @param int $responseSeqNo
     * @return \MoniBounce\StructType\MatchResponse
     */
    public function setResponseSeqNo($responseSeqNo = null)
    {
        // validation for constraint: int
        if (!is_null($responseSeqNo) && !is_numeric($responseSeqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseSeqNo)), __LINE__);
        }
        $this->ResponseSeqNo = $responseSeqNo;
        return $this;
    }
    /**
     * Get Outcome value
     * @return bool|null
     */
    public function getOutcome()
    {
        return $this->Outcome;
    }
    /**
     * Set Outcome value
     * @param bool $outcome
     * @return \MoniBounce\StructType\MatchResponse
     */
    public function setOutcome($outcome = null)
    {
        $this->Outcome = $outcome;
        return $this;
    }
    /**
     * Get MatchResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MoniBounce\StructType\MatchResult|null
     */
    public function getMatchResult()
    {
        return isset($this->MatchResult) ? $this->MatchResult : null;
    }
    /**
     * Set MatchResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \MoniBounce\StructType\MatchResult $matchResult
     * @return \MoniBounce\StructType\MatchResponse
     */
    public function setMatchResult(\MoniBounce\StructType\MatchResult $matchResult = null)
    {
        if (is_null($matchResult) || (is_array($matchResult) && empty($matchResult))) {
            unset($this->MatchResult);
        } else {
            $this->MatchResult = $matchResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniBounce\StructType\MatchResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
