<?php

namespace MoniBounce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveMatchComment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniBounce\StructType\SaveMatchComment $parameters
     * @return \MoniBounce\StructType\SaveMatchCommentResponse|bool
     */
    public function SaveMatchComment(\MoniBounce\StructType\SaveMatchComment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveMatchComment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMatchResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniBounce\StructType\SaveMatchResponse $parameters
     * @return \MoniBounce\StructType\SaveMatchResponseResponse|bool
     */
    public function SaveMatchResponse(\MoniBounce\StructType\SaveMatchResponse $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveMatchResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniBounce\StructType\SaveMatchCommentResponse|\MoniBounce\StructType\SaveMatchResponseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
