<?php

namespace MoniBounce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchResults StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchResults
 * @subpackage Structs
 */
class BatchResults extends AbstractStructBase
{
    /**
     * The MatchResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \MoniBounce\StructType\MatchResult[]
     */
    public $MatchResult;
    /**
     * Constructor method for BatchResults
     * @uses BatchResults::setMatchResult()
     * @param \MoniBounce\StructType\MatchResult[] $matchResult
     */
    public function __construct(array $matchResult = array())
    {
        $this
            ->setMatchResult($matchResult);
    }
    /**
     * Get MatchResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MoniBounce\StructType\MatchResult[]|null
     */
    public function getMatchResult()
    {
        return isset($this->MatchResult) ? $this->MatchResult : null;
    }
    /**
     * Set MatchResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \MoniBounce\StructType\MatchResult[] $matchResult
     * @return \MoniBounce\StructType\BatchResults
     */
    public function setMatchResult(array $matchResult = array())
    {
        foreach ($matchResult as $batchResultsMatchResultItem) {
            // validation for constraint: itemType
            if (!$batchResultsMatchResultItem instanceof \MoniBounce\StructType\MatchResult) {
                throw new \InvalidArgumentException(sprintf('The MatchResult property can only contain items of \MoniBounce\StructType\MatchResult, "%s" given', is_object($batchResultsMatchResultItem) ? get_class($batchResultsMatchResultItem) : gettype($batchResultsMatchResultItem)), __LINE__);
            }
        }
        if (is_null($matchResult) || (is_array($matchResult) && empty($matchResult))) {
            unset($this->MatchResult);
        } else {
            $this->MatchResult = $matchResult;
        }
        return $this;
    }
    /**
     * Add item to MatchResult value
     * @throws \InvalidArgumentException
     * @param \MoniBounce\StructType\MatchResult $item
     * @return \MoniBounce\StructType\BatchResults
     */
    public function addToMatchResult(\MoniBounce\StructType\MatchResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \MoniBounce\StructType\MatchResult) {
            throw new \InvalidArgumentException(sprintf('The MatchResult property can only contain items of \MoniBounce\StructType\MatchResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MatchResult[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniBounce\StructType\BatchResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
