<?php

namespace MoniBounce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Match ServiceType
 * @subpackage Services
 */
class Match extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Match
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniBounce\StructType\Match $parameters
     * @return \MoniBounce\StructType\MatchResponse|bool
     */
    public function Match(\MoniBounce\StructType\Match $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Match($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniBounce\StructType\MatchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
