<?php

namespace MoniBounce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchComment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MatchComment
 * @subpackage Structs
 */
class MatchComment extends AbstractStructBase
{
    /**
     * The MatchID
     * @var int
     */
    public $MatchID;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The ResponseID
     * @var int
     */
    public $ResponseID;
    /**
     * Constructor method for MatchComment
     * @uses MatchComment::setMatchID()
     * @uses MatchComment::setComment()
     * @uses MatchComment::setResponseID()
     * @param int $matchID
     * @param string $comment
     * @param int $responseID
     */
    public function __construct($matchID = null, $comment = null, $responseID = null)
    {
        $this
            ->setMatchID($matchID)
            ->setComment($comment)
            ->setResponseID($responseID);
    }
    /**
     * Get MatchID value
     * @return int|null
     */
    public function getMatchID()
    {
        return $this->MatchID;
    }
    /**
     * Set MatchID value
     * @param int $matchID
     * @return \MoniBounce\StructType\MatchComment
     */
    public function setMatchID($matchID = null)
    {
        // validation for constraint: int
        if (!is_null($matchID) && !is_numeric($matchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($matchID)), __LINE__);
        }
        $this->MatchID = $matchID;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \MoniBounce\StructType\MatchComment
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get ResponseID value
     * @return int|null
     */
    public function getResponseID()
    {
        return $this->ResponseID;
    }
    /**
     * Set ResponseID value
     * @param int $responseID
     * @return \MoniBounce\StructType\MatchComment
     */
    public function setResponseID($responseID = null)
    {
        // validation for constraint: int
        if (!is_null($responseID) && !is_numeric($responseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseID)), __LINE__);
        }
        $this->ResponseID = $responseID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MoniBounce\StructType\MatchComment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
