<?php

namespace MoniBounce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Batch ServiceType
 * @subpackage Services
 */
class Batch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BatchMatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MoniBounce\StructType\BatchMatch $parameters
     * @return \MoniBounce\StructType\BatchMatchResponse|bool
     */
    public function BatchMatch(\MoniBounce\StructType\BatchMatch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BatchMatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MoniBounce\StructType\BatchMatchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
