<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageResponse StructType
 * @subpackage Structs
 */
class MessageResponse extends AbstractStructBase
{
    /**
     * The TimeStamp
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TimeStamp;
    /**
     * The Idempotence
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Idempotence;
    /**
     * The ExpirationTimeStamp
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ExpirationTimeStamp;
    /**
     * The CredentialsResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CredentialsResponse
     */
    public $CredentialsResponse;
    /**
     * The GroupId
     * @var string
     */
    public $GroupId;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The ResultLanguage
     * @var string
     */
    public $ResultLanguage;
    /**
     * The ResultCode
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultDescription
     * @var string
     */
    public $ResultDescription;
    /**
     * Constructor method for MessageResponse
     * @uses MessageResponse::setTimeStamp()
     * @uses MessageResponse::setIdempotence()
     * @uses MessageResponse::setExpirationTimeStamp()
     * @uses MessageResponse::setCredentialsResponse()
     * @uses MessageResponse::setGroupId()
     * @uses MessageResponse::setId()
     * @uses MessageResponse::setResultLanguage()
     * @uses MessageResponse::setResultCode()
     * @uses MessageResponse::setResultDescription()
     * @param string $timeStamp
     * @param string $idempotence
     * @param string $expirationTimeStamp
     * @param \StructType\CredentialsResponse $credentialsResponse
     * @param string $groupId
     * @param string $id
     * @param string $resultLanguage
     * @param string $resultCode
     * @param string $resultDescription
     */
    public function __construct($timeStamp = null, $idempotence = null, $expirationTimeStamp = null, \StructType\CredentialsResponse $credentialsResponse = null, $groupId = null, $id = null, $resultLanguage = null, $resultCode = null, $resultDescription = null)
    {
        $this
            ->setTimeStamp($timeStamp)
            ->setIdempotence($idempotence)
            ->setExpirationTimeStamp($expirationTimeStamp)
            ->setCredentialsResponse($credentialsResponse)
            ->setGroupId($groupId)
            ->setId($id)
            ->setResultLanguage($resultLanguage)
            ->setResultCode($resultCode)
            ->setResultDescription($resultDescription);
    }
    /**
     * Get TimeStamp value
     * @return string
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\MessageResponse
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Idempotence value
     * @return string
     */
    public function getIdempotence()
    {
        return $this->Idempotence;
    }
    /**
     * Set Idempotence value
     * @uses \EnumType\MessageIdempotence::valueIsValid()
     * @uses \EnumType\MessageIdempotence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idempotence
     * @return \StructType\MessageResponse
     */
    public function setIdempotence($idempotence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageIdempotence::valueIsValid($idempotence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageIdempotence', is_array($idempotence) ? implode(', ', $idempotence) : var_export($idempotence, true), implode(', ', \EnumType\MessageIdempotence::getValidValues())), __LINE__);
        }
        $this->Idempotence = $idempotence;
        return $this;
    }
    /**
     * Get ExpirationTimeStamp value
     * @return string
     */
    public function getExpirationTimeStamp()
    {
        return $this->ExpirationTimeStamp;
    }
    /**
     * Set ExpirationTimeStamp value
     * @param string $expirationTimeStamp
     * @return \StructType\MessageResponse
     */
    public function setExpirationTimeStamp($expirationTimeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($expirationTimeStamp) && !is_string($expirationTimeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationTimeStamp, true), gettype($expirationTimeStamp)), __LINE__);
        }
        $this->ExpirationTimeStamp = $expirationTimeStamp;
        return $this;
    }
    /**
     * Get CredentialsResponse value
     * @return \StructType\CredentialsResponse|null
     */
    public function getCredentialsResponse()
    {
        return $this->CredentialsResponse;
    }
    /**
     * Set CredentialsResponse value
     * @param \StructType\CredentialsResponse $credentialsResponse
     * @return \StructType\MessageResponse
     */
    public function setCredentialsResponse(\StructType\CredentialsResponse $credentialsResponse = null)
    {
        $this->CredentialsResponse = $credentialsResponse;
        return $this;
    }
    /**
     * Get GroupId value
     * @return string|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param string $groupId
     * @return \StructType\MessageResponse
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\MessageResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ResultLanguage value
     * @return string|null
     */
    public function getResultLanguage()
    {
        return $this->ResultLanguage;
    }
    /**
     * Set ResultLanguage value
     * @param string $resultLanguage
     * @return \StructType\MessageResponse
     */
    public function setResultLanguage($resultLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($resultLanguage) && !is_string($resultLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultLanguage, true), gettype($resultLanguage)), __LINE__);
        }
        $this->ResultLanguage = $resultLanguage;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\MessageResponse
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultDescription value
     * @return string|null
     */
    public function getResultDescription()
    {
        return $this->ResultDescription;
    }
    /**
     * Set ResultDescription value
     * @param string $resultDescription
     * @return \StructType\MessageResponse
     */
    public function setResultDescription($resultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($resultDescription) && !is_string($resultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultDescription, true), gettype($resultDescription)), __LINE__);
        }
        $this->ResultDescription = $resultDescription;
        return $this;
    }
}
