<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageCredentials StructType
 * @subpackage Structs
 */
class MessageCredentials extends AbstractStructBase
{
    /**
     * The Domain
     * @var string
     */
    public $Domain;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * Constructor method for MessageCredentials
     * @uses MessageCredentials::setDomain()
     * @uses MessageCredentials::setId()
     * @uses MessageCredentials::setPassword()
     * @param string $domain
     * @param string $id
     * @param string $password
     */
    public function __construct($domain = null, $id = null, $password = null)
    {
        $this
            ->setDomain($domain)
            ->setId($id)
            ->setPassword($password);
    }
    /**
     * Get Domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param string $domain
     * @return \StructType\MessageCredentials
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\MessageCredentials
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\MessageCredentials
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
