<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The TimeStamp
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TimeStamp;
    /**
     * The Idempotence
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Idempotence;
    /**
     * The Credential
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MessageCredentials
     */
    public $Credential;
    /**
     * The GroupId
     * @var string
     */
    public $GroupId;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Message
     * @uses Message::setTimeStamp()
     * @uses Message::setIdempotence()
     * @uses Message::setCredential()
     * @uses Message::setGroupId()
     * @uses Message::setId()
     * @param string $timeStamp
     * @param string $idempotence
     * @param \StructType\MessageCredentials $credential
     * @param string $groupId
     * @param string $id
     */
    public function __construct($timeStamp = null, $idempotence = null, \StructType\MessageCredentials $credential = null, $groupId = null, $id = null)
    {
        $this
            ->setTimeStamp($timeStamp)
            ->setIdempotence($idempotence)
            ->setCredential($credential)
            ->setGroupId($groupId)
            ->setId($id);
    }
    /**
     * Get TimeStamp value
     * @return string
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\Message
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Idempotence value
     * @return string
     */
    public function getIdempotence()
    {
        return $this->Idempotence;
    }
    /**
     * Set Idempotence value
     * @uses \EnumType\MessageIdempotence::valueIsValid()
     * @uses \EnumType\MessageIdempotence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idempotence
     * @return \StructType\Message
     */
    public function setIdempotence($idempotence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageIdempotence::valueIsValid($idempotence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageIdempotence', is_array($idempotence) ? implode(', ', $idempotence) : var_export($idempotence, true), implode(', ', \EnumType\MessageIdempotence::getValidValues())), __LINE__);
        }
        $this->Idempotence = $idempotence;
        return $this;
    }
    /**
     * Get Credential value
     * @return \StructType\MessageCredentials|null
     */
    public function getCredential()
    {
        return $this->Credential;
    }
    /**
     * Set Credential value
     * @param \StructType\MessageCredentials $credential
     * @return \StructType\Message
     */
    public function setCredential(\StructType\MessageCredentials $credential = null)
    {
        $this->Credential = $credential;
        return $this;
    }
    /**
     * Get GroupId value
     * @return string|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param string $groupId
     * @return \StructType\Message
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Message
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
