<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MGResponse StructType
 * Meta information extracted from the WSDL
 * - type: tns:MGResponse
 * @subpackage Structs
 */
class MGResponse extends AbstractStructBase
{
    /**
     * The MessageResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MessageResponse
     */
    public $MessageResponse;
    /**
     * The ProductResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductResponse[]
     */
    public $ProductResponse;
    /**
     * Constructor method for MGResponse
     * @uses MGResponse::setMessageResponse()
     * @uses MGResponse::setProductResponse()
     * @param \StructType\MessageResponse $messageResponse
     * @param \StructType\ProductResponse[] $productResponse
     */
    public function __construct(\StructType\MessageResponse $messageResponse = null, array $productResponse = array())
    {
        $this
            ->setMessageResponse($messageResponse)
            ->setProductResponse($productResponse);
    }
    /**
     * Get MessageResponse value
     * @return \StructType\MessageResponse|null
     */
    public function getMessageResponse()
    {
        return $this->MessageResponse;
    }
    /**
     * Set MessageResponse value
     * @param \StructType\MessageResponse $messageResponse
     * @return \StructType\MGResponse
     */
    public function setMessageResponse(\StructType\MessageResponse $messageResponse = null)
    {
        $this->MessageResponse = $messageResponse;
        return $this;
    }
    /**
     * Get ProductResponse value
     * @return \StructType\ProductResponse[]|null
     */
    public function getProductResponse()
    {
        return $this->ProductResponse;
    }
    /**
     * This method is responsible for validating the values passed to the setProductResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductResponseForArrayConstraintsFromSetProductResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mGResponseProductResponseItem) {
            // validation for constraint: itemType
            if (!$mGResponseProductResponseItem instanceof \StructType\ProductResponse) {
                $invalidValues[] = is_object($mGResponseProductResponseItem) ? get_class($mGResponseProductResponseItem) : sprintf('%s(%s)', gettype($mGResponseProductResponseItem), var_export($mGResponseProductResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductResponse property can only contain items of type \StructType\ProductResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductResponse[] $productResponse
     * @return \StructType\MGResponse
     */
    public function setProductResponse(array $productResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($productResponseArrayErrorMessage = self::validateProductResponseForArrayConstraintsFromSetProductResponse($productResponse))) {
            throw new \InvalidArgumentException($productResponseArrayErrorMessage, __LINE__);
        }
        $this->ProductResponse = $productResponse;
        return $this;
    }
    /**
     * Add item to ProductResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductResponse $item
     * @return \StructType\MGResponse
     */
    public function addToProductResponse(\StructType\ProductResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductResponse) {
            throw new \InvalidArgumentException(sprintf('The ProductResponse property can only contain items of type \StructType\ProductResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductResponse[] = $item;
        return $this;
    }
}
