<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MGRequest StructType
 * Meta information extracted from the WSDL
 * - type: tns:MGRequest
 * @subpackage Structs
 */
class MGRequest extends AbstractStructBase
{
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Message
     */
    public $Message;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MessageProduct[]
     */
    public $Product;
    /**
     * Constructor method for MGRequest
     * @uses MGRequest::setMessage()
     * @uses MGRequest::setProduct()
     * @param \StructType\Message $message
     * @param \StructType\MessageProduct[] $product
     */
    public function __construct(\StructType\Message $message = null, array $product = array())
    {
        $this
            ->setMessage($message)
            ->setProduct($product);
    }
    /**
     * Get Message value
     * @return \StructType\Message|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \StructType\Message $message
     * @return \StructType\MGRequest
     */
    public function setMessage(\StructType\Message $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\MessageProduct[]|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * This method is responsible for validating the values passed to the setProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductForArrayConstraintsFromSetProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mGRequestProductItem) {
            // validation for constraint: itemType
            if (!$mGRequestProductItem instanceof \StructType\MessageProduct) {
                $invalidValues[] = is_object($mGRequestProductItem) ? get_class($mGRequestProductItem) : sprintf('%s(%s)', gettype($mGRequestProductItem), var_export($mGRequestProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Product property can only contain items of type \StructType\MessageProduct, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Product value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageProduct[] $product
     * @return \StructType\MGRequest
     */
    public function setProduct(array $product = array())
    {
        // validation for constraint: array
        if ('' !== ($productArrayErrorMessage = self::validateProductForArrayConstraintsFromSetProduct($product))) {
            throw new \InvalidArgumentException($productArrayErrorMessage, __LINE__);
        }
        $this->Product = $product;
        return $this;
    }
    /**
     * Add item to Product value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageProduct $item
     * @return \StructType\MGRequest
     */
    public function addToProduct(\StructType\MessageProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MessageProduct) {
            throw new \InvalidArgumentException(sprintf('The Product property can only contain items of type \StructType\MessageProduct, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Product[] = $item;
        return $this;
    }
}
