<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MessageIdempotence EnumType
 * @subpackage Enumerations
 */
class MessageIdempotence extends AbstractStructEnumBase
{
    /**
     * Constant for value 'unique'
     * @return string 'unique'
     */
    const VALUE_UNIQUE = 'unique';
    /**
     * Constant for value 'idempotent'
     * @return string 'idempotent'
     */
    const VALUE_IDEMPOTENT = 'idempotent';
    /**
     * Return allowed values
     * @uses self::VALUE_UNIQUE
     * @uses self::VALUE_IDEMPOTENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNIQUE,
            self::VALUE_IDEMPOTENT,
        );
    }
}
