<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductResponse StructType
 * @subpackage Structs
 */
class ProductResponse extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The ServiceId
     * @var string
     */
    public $ServiceId;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The ResultLanguage
     * @var string
     */
    public $ResultLanguage;
    /**
     * The ResultCode
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultDescription
     * @var string
     */
    public $ResultDescription;
    /**
     * Constructor method for ProductResponse
     * @uses ProductResponse::setAny()
     * @uses ProductResponse::setServiceId()
     * @uses ProductResponse::setId()
     * @uses ProductResponse::setVersion()
     * @uses ProductResponse::setResultLanguage()
     * @uses ProductResponse::setResultCode()
     * @uses ProductResponse::setResultDescription()
     * @param \DOMDocument $any
     * @param string $serviceId
     * @param string $id
     * @param string $version
     * @param string $resultLanguage
     * @param string $resultCode
     * @param string $resultDescription
     */
    public function __construct(\DOMDocument $any = null, $serviceId = null, $id = null, $version = null, $resultLanguage = null, $resultCode = null, $resultDescription = null)
    {
        $this
            ->setAny($any)
            ->setServiceId($serviceId)
            ->setId($id)
            ->setVersion($version)
            ->setResultLanguage($resultLanguage)
            ->setResultCode($resultCode)
            ->setResultDescription($resultDescription);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\ProductResponse
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get ServiceId value
     * @return string|null
     */
    public function getServiceId()
    {
        return $this->ServiceId;
    }
    /**
     * Set ServiceId value
     * @param string $serviceId
     * @return \StructType\ProductResponse
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->ServiceId = $serviceId;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ProductResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\ProductResponse
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get ResultLanguage value
     * @return string|null
     */
    public function getResultLanguage()
    {
        return $this->ResultLanguage;
    }
    /**
     * Set ResultLanguage value
     * @param string $resultLanguage
     * @return \StructType\ProductResponse
     */
    public function setResultLanguage($resultLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($resultLanguage) && !is_string($resultLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultLanguage, true), gettype($resultLanguage)), __LINE__);
        }
        $this->ResultLanguage = $resultLanguage;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\ProductResponse
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultDescription value
     * @return string|null
     */
    public function getResultDescription()
    {
        return $this->ResultDescription;
    }
    /**
     * Set ResultDescription value
     * @param string $resultDescription
     * @return \StructType\ProductResponse
     */
    public function setResultDescription($resultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($resultDescription) && !is_string($resultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultDescription, true), gettype($resultDescription)), __LINE__);
        }
        $this->ResultDescription = $resultDescription;
        return $this;
    }
}
