<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendPostcard StructType
 * @subpackage Structs
 */
class SendPostcard extends AbstractStructBase
{
    /**
     * The postcardID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $postcardID;
    /**
     * The mailingListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailingListID;
    /**
     * The sendNow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $sendNow;
    /**
     * The dateToSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dateToSend;
    /**
     * The emailNotification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $emailNotification;
    /**
     * The costOfMailing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $costOfMailing;
    /**
     * The numberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfPages;
    /**
     * The numberOfSheets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfSheets;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The firstClassStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstClassStr;
    /**
     * The costCentreStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $costCentreStr;
    /**
     * The affiliateGUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $affiliateGUID;
    /**
     * The mailingNameOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailingNameOverride;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for SendPostcard
     * @uses SendPostcard::setPostcardID()
     * @uses SendPostcard::setMailingListID()
     * @uses SendPostcard::setSendNow()
     * @uses SendPostcard::setDateToSend()
     * @uses SendPostcard::setEmailNotification()
     * @uses SendPostcard::setCostOfMailing()
     * @uses SendPostcard::setNumberOfPages()
     * @uses SendPostcard::setNumberOfSheets()
     * @uses SendPostcard::setLoginToken()
     * @uses SendPostcard::setFirstClassStr()
     * @uses SendPostcard::setCostCentreStr()
     * @uses SendPostcard::setAffiliateGUID()
     * @uses SendPostcard::setMailingNameOverride()
     * @uses SendPostcard::setReturnMessage()
     * @param int $postcardID
     * @param int $mailingListID
     * @param bool $sendNow
     * @param string $dateToSend
     * @param bool $emailNotification
     * @param float $costOfMailing
     * @param int $numberOfPages
     * @param int $numberOfSheets
     * @param string $loginToken
     * @param string $firstClassStr
     * @param string $costCentreStr
     * @param string $affiliateGUID
     * @param string $mailingNameOverride
     * @param string $returnMessage
     */
    public function __construct($postcardID = null, $mailingListID = null, $sendNow = null, $dateToSend = null, $emailNotification = null, $costOfMailing = null, $numberOfPages = null, $numberOfSheets = null, $loginToken = null, $firstClassStr = null, $costCentreStr = null, $affiliateGUID = null, $mailingNameOverride = null, $returnMessage = null)
    {
        $this
            ->setPostcardID($postcardID)
            ->setMailingListID($mailingListID)
            ->setSendNow($sendNow)
            ->setDateToSend($dateToSend)
            ->setEmailNotification($emailNotification)
            ->setCostOfMailing($costOfMailing)
            ->setNumberOfPages($numberOfPages)
            ->setNumberOfSheets($numberOfSheets)
            ->setLoginToken($loginToken)
            ->setFirstClassStr($firstClassStr)
            ->setCostCentreStr($costCentreStr)
            ->setAffiliateGUID($affiliateGUID)
            ->setMailingNameOverride($mailingNameOverride)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get postcardID value
     * @return int
     */
    public function getPostcardID()
    {
        return $this->postcardID;
    }
    /**
     * Set postcardID value
     * @param int $postcardID
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setPostcardID($postcardID = null)
    {
        // validation for constraint: int
        if (!is_null($postcardID) && !(is_int($postcardID) || ctype_digit($postcardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postcardID, true), gettype($postcardID)), __LINE__);
        }
        $this->postcardID = $postcardID;
        return $this;
    }
    /**
     * Get mailingListID value
     * @return int
     */
    public function getMailingListID()
    {
        return $this->mailingListID;
    }
    /**
     * Set mailingListID value
     * @param int $mailingListID
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setMailingListID($mailingListID = null)
    {
        // validation for constraint: int
        if (!is_null($mailingListID) && !(is_int($mailingListID) || ctype_digit($mailingListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailingListID, true), gettype($mailingListID)), __LINE__);
        }
        $this->mailingListID = $mailingListID;
        return $this;
    }
    /**
     * Get sendNow value
     * @return bool
     */
    public function getSendNow()
    {
        return $this->sendNow;
    }
    /**
     * Set sendNow value
     * @param bool $sendNow
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setSendNow($sendNow = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNow) && !is_bool($sendNow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNow, true), gettype($sendNow)), __LINE__);
        }
        $this->sendNow = $sendNow;
        return $this;
    }
    /**
     * Get dateToSend value
     * @return string
     */
    public function getDateToSend()
    {
        return $this->dateToSend;
    }
    /**
     * Set dateToSend value
     * @param string $dateToSend
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setDateToSend($dateToSend = null)
    {
        // validation for constraint: string
        if (!is_null($dateToSend) && !is_string($dateToSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateToSend, true), gettype($dateToSend)), __LINE__);
        }
        $this->dateToSend = $dateToSend;
        return $this;
    }
    /**
     * Get emailNotification value
     * @return bool
     */
    public function getEmailNotification()
    {
        return $this->emailNotification;
    }
    /**
     * Set emailNotification value
     * @param bool $emailNotification
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setEmailNotification($emailNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailNotification) && !is_bool($emailNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailNotification, true), gettype($emailNotification)), __LINE__);
        }
        $this->emailNotification = $emailNotification;
        return $this;
    }
    /**
     * Get costOfMailing value
     * @return float
     */
    public function getCostOfMailing()
    {
        return $this->costOfMailing;
    }
    /**
     * Set costOfMailing value
     * @param float $costOfMailing
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setCostOfMailing($costOfMailing = null)
    {
        // validation for constraint: float
        if (!is_null($costOfMailing) && !(is_float($costOfMailing) || is_numeric($costOfMailing))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfMailing, true), gettype($costOfMailing)), __LINE__);
        }
        $this->costOfMailing = $costOfMailing;
        return $this;
    }
    /**
     * Get numberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->numberOfPages;
    }
    /**
     * Set numberOfPages value
     * @param int $numberOfPages
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->numberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get numberOfSheets value
     * @return int
     */
    public function getNumberOfSheets()
    {
        return $this->numberOfSheets;
    }
    /**
     * Set numberOfSheets value
     * @param int $numberOfSheets
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setNumberOfSheets($numberOfSheets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSheets) && !(is_int($numberOfSheets) || ctype_digit($numberOfSheets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSheets, true), gettype($numberOfSheets)), __LINE__);
        }
        $this->numberOfSheets = $numberOfSheets;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get firstClassStr value
     * @return string|null
     */
    public function getFirstClassStr()
    {
        return $this->firstClassStr;
    }
    /**
     * Set firstClassStr value
     * @param string $firstClassStr
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setFirstClassStr($firstClassStr = null)
    {
        // validation for constraint: string
        if (!is_null($firstClassStr) && !is_string($firstClassStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstClassStr, true), gettype($firstClassStr)), __LINE__);
        }
        $this->firstClassStr = $firstClassStr;
        return $this;
    }
    /**
     * Get costCentreStr value
     * @return string|null
     */
    public function getCostCentreStr()
    {
        return $this->costCentreStr;
    }
    /**
     * Set costCentreStr value
     * @param string $costCentreStr
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setCostCentreStr($costCentreStr = null)
    {
        // validation for constraint: string
        if (!is_null($costCentreStr) && !is_string($costCentreStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCentreStr, true), gettype($costCentreStr)), __LINE__);
        }
        $this->costCentreStr = $costCentreStr;
        return $this;
    }
    /**
     * Get affiliateGUID value
     * @return string|null
     */
    public function getAffiliateGUID()
    {
        return $this->affiliateGUID;
    }
    /**
     * Set affiliateGUID value
     * @param string $affiliateGUID
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setAffiliateGUID($affiliateGUID = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateGUID) && !is_string($affiliateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateGUID, true), gettype($affiliateGUID)), __LINE__);
        }
        $this->affiliateGUID = $affiliateGUID;
        return $this;
    }
    /**
     * Get mailingNameOverride value
     * @return string|null
     */
    public function getMailingNameOverride()
    {
        return $this->mailingNameOverride;
    }
    /**
     * Set mailingNameOverride value
     * @param string $mailingNameOverride
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setMailingNameOverride($mailingNameOverride = null)
    {
        // validation for constraint: string
        if (!is_null($mailingNameOverride) && !is_string($mailingNameOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingNameOverride, true), gettype($mailingNameOverride)), __LINE__);
        }
        $this->mailingNameOverride = $mailingNameOverride;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\pestopancake\viapost-php\StructType\SendPostcard
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
