<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchAddressResponse StructType
 * @subpackage Structs
 */
class SearchAddressResponse extends AbstractStructBase
{
    /**
     * The PafCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PafCode;
    /**
     * The SearchAddressResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress
     */
    public $SearchAddressResult;
    /**
     * The ReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnMessage;
    /**
     * Constructor method for SearchAddressResponse
     * @uses SearchAddressResponse::setPafCode()
     * @uses SearchAddressResponse::setSearchAddressResult()
     * @uses SearchAddressResponse::setReturnMessage()
     * @param int $pafCode
     * @param \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress $searchAddressResult
     * @param string $returnMessage
     */
    public function __construct($pafCode = null, \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress $searchAddressResult = null, $returnMessage = null)
    {
        $this
            ->setPafCode($pafCode)
            ->setSearchAddressResult($searchAddressResult)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get PafCode value
     * @return int
     */
    public function getPafCode()
    {
        return $this->PafCode;
    }
    /**
     * Set PafCode value
     * @param int $pafCode
     * @return \\pestopancake\viapost-php\StructType\SearchAddressResponse
     */
    public function setPafCode($pafCode = null)
    {
        // validation for constraint: int
        if (!is_null($pafCode) && !(is_int($pafCode) || ctype_digit($pafCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pafCode, true), gettype($pafCode)), __LINE__);
        }
        $this->PafCode = $pafCode;
        return $this;
    }
    /**
     * Get SearchAddressResult value
     * @return \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress|null
     */
    public function getSearchAddressResult()
    {
        return $this->SearchAddressResult;
    }
    /**
     * Set SearchAddressResult value
     * @param \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress $searchAddressResult
     * @return \\pestopancake\viapost-php\StructType\SearchAddressResponse
     */
    public function setSearchAddressResult(\\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress $searchAddressResult = null)
    {
        $this->SearchAddressResult = $searchAddressResult;
        return $this;
    }
    /**
     * Get ReturnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->ReturnMessage;
    }
    /**
     * Set ReturnMessage value
     * @param string $returnMessage
     * @return \\pestopancake\viapost-php\StructType\SearchAddressResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->ReturnMessage = $returnMessage;
        return $this;
    }
}
