<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewLetter StructType
 * @subpackage Structs
 */
class PreviewLetter extends AbstractStructBase
{
    /**
     * The letterId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $letterId;
    /**
     * The LoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginToken;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\pestopancake\viapost-php\StructType\PostalAddress
     */
    public $Address;
    /**
     * The letterData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $letterData;
    /**
     * The ReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnMessage;
    /**
     * Constructor method for PreviewLetter
     * @uses PreviewLetter::setLetterId()
     * @uses PreviewLetter::setLoginToken()
     * @uses PreviewLetter::setAddress()
     * @uses PreviewLetter::setLetterData()
     * @uses PreviewLetter::setReturnMessage()
     * @param int $letterId
     * @param string $loginToken
     * @param \\pestopancake\viapost-php\StructType\PostalAddress $address
     * @param string $letterData
     * @param string $returnMessage
     */
    public function __construct($letterId = null, $loginToken = null, \\pestopancake\viapost-php\StructType\PostalAddress $address = null, $letterData = null, $returnMessage = null)
    {
        $this
            ->setLetterId($letterId)
            ->setLoginToken($loginToken)
            ->setAddress($address)
            ->setLetterData($letterData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get letterId value
     * @return int
     */
    public function getLetterId()
    {
        return $this->letterId;
    }
    /**
     * Set letterId value
     * @param int $letterId
     * @return \\pestopancake\viapost-php\StructType\PreviewLetter
     */
    public function setLetterId($letterId = null)
    {
        // validation for constraint: int
        if (!is_null($letterId) && !(is_int($letterId) || ctype_digit($letterId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterId, true), gettype($letterId)), __LINE__);
        }
        $this->letterId = $letterId;
        return $this;
    }
    /**
     * Get LoginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->LoginToken;
    }
    /**
     * Set LoginToken value
     * @param string $loginToken
     * @return \\pestopancake\viapost-php\StructType\PreviewLetter
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->LoginToken = $loginToken;
        return $this;
    }
    /**
     * Get Address value
     * @return \\pestopancake\viapost-php\StructType\PostalAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \\pestopancake\viapost-php\StructType\PostalAddress $address
     * @return \\pestopancake\viapost-php\StructType\PreviewLetter
     */
    public function setAddress(\\pestopancake\viapost-php\StructType\PostalAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get letterData value
     * @return string|null
     */
    public function getLetterData()
    {
        return $this->letterData;
    }
    /**
     * Set letterData value
     * @param string $letterData
     * @return \\pestopancake\viapost-php\StructType\PreviewLetter
     */
    public function setLetterData($letterData = null)
    {
        // validation for constraint: string
        if (!is_null($letterData) && !is_string($letterData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letterData, true), gettype($letterData)), __LINE__);
        }
        $this->letterData = $letterData;
        return $this;
    }
    /**
     * Get ReturnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->ReturnMessage;
    }
    /**
     * Set ReturnMessage value
     * @param string $returnMessage
     * @return \\pestopancake\viapost-php\StructType\PreviewLetter
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->ReturnMessage = $returnMessage;
        return $this;
    }
}
