<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewDocumentMailingList StructType
 * @subpackage Structs
 */
class PreviewDocumentMailingList extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentID;
    /**
     * The colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $colour;
    /**
     * The simplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $simplex;
    /**
     * The mailingListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mailingListID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The documentData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentData;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for PreviewDocumentMailingList
     * @uses PreviewDocumentMailingList::setDocumentType()
     * @uses PreviewDocumentMailingList::setDocumentID()
     * @uses PreviewDocumentMailingList::setColour()
     * @uses PreviewDocumentMailingList::setSimplex()
     * @uses PreviewDocumentMailingList::setMailingListID()
     * @uses PreviewDocumentMailingList::setLoginToken()
     * @uses PreviewDocumentMailingList::setDocumentData()
     * @uses PreviewDocumentMailingList::setReturnMessage()
     * @param string $documentType
     * @param int $documentID
     * @param bool $colour
     * @param bool $simplex
     * @param int $mailingListID
     * @param string $loginToken
     * @param string $documentData
     * @param string $returnMessage
     */
    public function __construct($documentType = null, $documentID = null, $colour = null, $simplex = null, $mailingListID = null, $loginToken = null, $documentData = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setDocumentID($documentID)
            ->setColour($colour)
            ->setSimplex($simplex)
            ->setMailingListID($mailingListID)
            ->setLoginToken($loginToken)
            ->setDocumentData($documentData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \\pestopancake\viapost-php\EnumType\DocumentType::valueIsValid()
     * @uses \\pestopancake\viapost-php\EnumType\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\\pestopancake\viapost-php\EnumType\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\pestopancake\viapost-php\EnumType\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \\pestopancake\viapost-php\EnumType\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get documentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param int $documentID
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->colour;
    }
    /**
     * Set colour value
     * @param bool $colour
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->colour = $colour;
        return $this;
    }
    /**
     * Get simplex value
     * @return bool
     */
    public function getSimplex()
    {
        return $this->simplex;
    }
    /**
     * Set simplex value
     * @param bool $simplex
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList
     */
    public function setSimplex($simplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplex) && !is_bool($simplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplex, true), gettype($simplex)), __LINE__);
        }
        $this->simplex = $simplex;
        return $this;
    }
    /**
     * Get mailingListID value
     * @return int
     */
    public function getMailingListID()
    {
        return $this->mailingListID;
    }
    /**
     * Set mailingListID value
     * @param int $mailingListID
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList
     */
    public function setMailingListID($mailingListID = null)
    {
        // validation for constraint: int
        if (!is_null($mailingListID) && !(is_int($mailingListID) || ctype_digit($mailingListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailingListID, true), gettype($mailingListID)), __LINE__);
        }
        $this->mailingListID = $mailingListID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get documentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->documentData;
    }
    /**
     * Set documentData value
     * @param string $documentData
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        $this->documentData = $documentData;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
