<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Postcard StructType
 * @subpackage Structs
 */
class Postcard extends AbstractStructBase
{
    /**
     * The PostcardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PostcardId;
    /**
     * The IsShared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsShared;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Postcard
     * @uses Postcard::setPostcardId()
     * @uses Postcard::setIsShared()
     * @uses Postcard::setName()
     * @uses Postcard::setDescription()
     * @param int $postcardId
     * @param bool $isShared
     * @param string $name
     * @param string $description
     */
    public function __construct($postcardId = null, $isShared = null, $name = null, $description = null)
    {
        $this
            ->setPostcardId($postcardId)
            ->setIsShared($isShared)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get PostcardId value
     * @return int
     */
    public function getPostcardId()
    {
        return $this->PostcardId;
    }
    /**
     * Set PostcardId value
     * @param int $postcardId
     * @return \\pestopancake\viapost-php\StructType\Postcard
     */
    public function setPostcardId($postcardId = null)
    {
        // validation for constraint: int
        if (!is_null($postcardId) && !(is_int($postcardId) || ctype_digit($postcardId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postcardId, true), gettype($postcardId)), __LINE__);
        }
        $this->PostcardId = $postcardId;
        return $this;
    }
    /**
     * Get IsShared value
     * @return bool
     */
    public function getIsShared()
    {
        return $this->IsShared;
    }
    /**
     * Set IsShared value
     * @param bool $isShared
     * @return \\pestopancake\viapost-php\StructType\Postcard
     */
    public function setIsShared($isShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShared) && !is_bool($isShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShared, true), gettype($isShared)), __LINE__);
        }
        $this->IsShared = $isShared;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \\pestopancake\viapost-php\StructType\Postcard
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\pestopancake\viapost-php\StructType\Postcard
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
