<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailPack StructType
 * @subpackage Structs
 */
class MailPack extends AbstractStructBase
{
    /**
     * The MailPackId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MailPackId;
    /**
     * The LetterId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LetterId;
    /**
     * The DateLastUpdated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateLastUpdated;
    /**
     * The IsShared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsShared;
    /**
     * The LetterType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LetterType;
    /**
     * The NumberOfLetterPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfLetterPages;
    /**
     * The LetterHeadId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LetterHeadId;
    /**
     * The ApplyLetterHeadToFirstPageOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ApplyLetterHeadToFirstPageOnly;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AttachmentIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\pestopancake\viapost-php\ArrayType\ArrayOfAnyType
     */
    public $AttachmentIds;
    /**
     * Constructor method for MailPack
     * @uses MailPack::setMailPackId()
     * @uses MailPack::setLetterId()
     * @uses MailPack::setDateLastUpdated()
     * @uses MailPack::setIsShared()
     * @uses MailPack::setLetterType()
     * @uses MailPack::setNumberOfLetterPages()
     * @uses MailPack::setLetterHeadId()
     * @uses MailPack::setApplyLetterHeadToFirstPageOnly()
     * @uses MailPack::setName()
     * @uses MailPack::setDescription()
     * @uses MailPack::setAttachmentIds()
     * @param int $mailPackId
     * @param int $letterId
     * @param string $dateLastUpdated
     * @param bool $isShared
     * @param string $letterType
     * @param int $numberOfLetterPages
     * @param int $letterHeadId
     * @param bool $applyLetterHeadToFirstPageOnly
     * @param string $name
     * @param string $description
     * @param \\pestopancake\viapost-php\ArrayType\ArrayOfAnyType $attachmentIds
     */
    public function __construct($mailPackId = null, $letterId = null, $dateLastUpdated = null, $isShared = null, $letterType = null, $numberOfLetterPages = null, $letterHeadId = null, $applyLetterHeadToFirstPageOnly = null, $name = null, $description = null, \\pestopancake\viapost-php\ArrayType\ArrayOfAnyType $attachmentIds = null)
    {
        $this
            ->setMailPackId($mailPackId)
            ->setLetterId($letterId)
            ->setDateLastUpdated($dateLastUpdated)
            ->setIsShared($isShared)
            ->setLetterType($letterType)
            ->setNumberOfLetterPages($numberOfLetterPages)
            ->setLetterHeadId($letterHeadId)
            ->setApplyLetterHeadToFirstPageOnly($applyLetterHeadToFirstPageOnly)
            ->setName($name)
            ->setDescription($description)
            ->setAttachmentIds($attachmentIds);
    }
    /**
     * Get MailPackId value
     * @return int
     */
    public function getMailPackId()
    {
        return $this->MailPackId;
    }
    /**
     * Set MailPackId value
     * @param int $mailPackId
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setMailPackId($mailPackId = null)
    {
        // validation for constraint: int
        if (!is_null($mailPackId) && !(is_int($mailPackId) || ctype_digit($mailPackId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailPackId, true), gettype($mailPackId)), __LINE__);
        }
        $this->MailPackId = $mailPackId;
        return $this;
    }
    /**
     * Get LetterId value
     * @return int
     */
    public function getLetterId()
    {
        return $this->LetterId;
    }
    /**
     * Set LetterId value
     * @param int $letterId
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setLetterId($letterId = null)
    {
        // validation for constraint: int
        if (!is_null($letterId) && !(is_int($letterId) || ctype_digit($letterId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterId, true), gettype($letterId)), __LINE__);
        }
        $this->LetterId = $letterId;
        return $this;
    }
    /**
     * Get DateLastUpdated value
     * @return string
     */
    public function getDateLastUpdated()
    {
        return $this->DateLastUpdated;
    }
    /**
     * Set DateLastUpdated value
     * @param string $dateLastUpdated
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setDateLastUpdated($dateLastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($dateLastUpdated) && !is_string($dateLastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateLastUpdated, true), gettype($dateLastUpdated)), __LINE__);
        }
        $this->DateLastUpdated = $dateLastUpdated;
        return $this;
    }
    /**
     * Get IsShared value
     * @return bool
     */
    public function getIsShared()
    {
        return $this->IsShared;
    }
    /**
     * Set IsShared value
     * @param bool $isShared
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setIsShared($isShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShared) && !is_bool($isShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShared, true), gettype($isShared)), __LINE__);
        }
        $this->IsShared = $isShared;
        return $this;
    }
    /**
     * Get LetterType value
     * @return string
     */
    public function getLetterType()
    {
        return $this->LetterType;
    }
    /**
     * Set LetterType value
     * @uses \\pestopancake\viapost-php\EnumType\APILetterType::valueIsValid()
     * @uses \\pestopancake\viapost-php\EnumType\APILetterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $letterType
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setLetterType($letterType = null)
    {
        // validation for constraint: enumeration
        if (!\\pestopancake\viapost-php\EnumType\APILetterType::valueIsValid($letterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \\pestopancake\viapost-php\EnumType\APILetterType', is_array($letterType) ? implode(', ', $letterType) : var_export($letterType, true), implode(', ', \\pestopancake\viapost-php\EnumType\APILetterType::getValidValues())), __LINE__);
        }
        $this->LetterType = $letterType;
        return $this;
    }
    /**
     * Get NumberOfLetterPages value
     * @return int
     */
    public function getNumberOfLetterPages()
    {
        return $this->NumberOfLetterPages;
    }
    /**
     * Set NumberOfLetterPages value
     * @param int $numberOfLetterPages
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setNumberOfLetterPages($numberOfLetterPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfLetterPages) && !(is_int($numberOfLetterPages) || ctype_digit($numberOfLetterPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfLetterPages, true), gettype($numberOfLetterPages)), __LINE__);
        }
        $this->NumberOfLetterPages = $numberOfLetterPages;
        return $this;
    }
    /**
     * Get LetterHeadId value
     * @return int
     */
    public function getLetterHeadId()
    {
        return $this->LetterHeadId;
    }
    /**
     * Set LetterHeadId value
     * @param int $letterHeadId
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setLetterHeadId($letterHeadId = null)
    {
        // validation for constraint: int
        if (!is_null($letterHeadId) && !(is_int($letterHeadId) || ctype_digit($letterHeadId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterHeadId, true), gettype($letterHeadId)), __LINE__);
        }
        $this->LetterHeadId = $letterHeadId;
        return $this;
    }
    /**
     * Get ApplyLetterHeadToFirstPageOnly value
     * @return bool
     */
    public function getApplyLetterHeadToFirstPageOnly()
    {
        return $this->ApplyLetterHeadToFirstPageOnly;
    }
    /**
     * Set ApplyLetterHeadToFirstPageOnly value
     * @param bool $applyLetterHeadToFirstPageOnly
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setApplyLetterHeadToFirstPageOnly($applyLetterHeadToFirstPageOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyLetterHeadToFirstPageOnly) && !is_bool($applyLetterHeadToFirstPageOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyLetterHeadToFirstPageOnly, true), gettype($applyLetterHeadToFirstPageOnly)), __LINE__);
        }
        $this->ApplyLetterHeadToFirstPageOnly = $applyLetterHeadToFirstPageOnly;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AttachmentIds value
     * @return \\pestopancake\viapost-php\ArrayType\ArrayOfAnyType|null
     */
    public function getAttachmentIds()
    {
        return $this->AttachmentIds;
    }
    /**
     * Set AttachmentIds value
     * @param \\pestopancake\viapost-php\ArrayType\ArrayOfAnyType $attachmentIds
     * @return \\pestopancake\viapost-php\StructType\MailPack
     */
    public function setAttachmentIds(\\pestopancake\viapost-php\ArrayType\ArrayOfAnyType $attachmentIds = null)
    {
        $this->AttachmentIds = $attachmentIds;
        return $this;
    }
}
