<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAddressesForPostcode StructType
 * @subpackage Structs
 */
class GetAddressesForPostcode extends AbstractStructBase
{
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The addresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress
     */
    public $addresses;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetAddressesForPostcode
     * @uses GetAddressesForPostcode::setPostcode()
     * @uses GetAddressesForPostcode::setAddresses()
     * @uses GetAddressesForPostcode::setReturnMessage()
     * @param string $postcode
     * @param \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress $addresses
     * @param string $returnMessage
     */
    public function __construct($postcode = null, \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress $addresses = null, $returnMessage = null)
    {
        $this
            ->setPostcode($postcode)
            ->setAddresses($addresses)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \\pestopancake\viapost-php\StructType\GetAddressesForPostcode
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get addresses value
     * @return \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress|null
     */
    public function getAddresses()
    {
        return $this->addresses;
    }
    /**
     * Set addresses value
     * @param \\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress $addresses
     * @return \\pestopancake\viapost-php\StructType\GetAddressesForPostcode
     */
    public function setAddresses(\\pestopancake\viapost-php\ArrayType\ArrayOfPostalAddress $addresses = null)
    {
        $this->addresses = $addresses;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \\pestopancake\viapost-php\StructType\GetAddressesForPostcode
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
