<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentHistory StructType
 * @subpackage Structs
 */
class DocumentHistory extends AbstractStructBase
{
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentId;
    /**
     * The DocumentStatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentStatusId;
    /**
     * The DateSent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateSent;
    /**
     * The Colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Colour;
    /**
     * The Simplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Simplex;
    /**
     * The DocumentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentName;
    /**
     * The PostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostCode;
    /**
     * Constructor method for DocumentHistory
     * @uses DocumentHistory::setDocumentId()
     * @uses DocumentHistory::setDocumentStatusId()
     * @uses DocumentHistory::setDateSent()
     * @uses DocumentHistory::setColour()
     * @uses DocumentHistory::setSimplex()
     * @uses DocumentHistory::setDocumentName()
     * @uses DocumentHistory::setPostCode()
     * @param int $documentId
     * @param int $documentStatusId
     * @param string $dateSent
     * @param bool $colour
     * @param bool $simplex
     * @param string $documentName
     * @param string $postCode
     */
    public function __construct($documentId = null, $documentStatusId = null, $dateSent = null, $colour = null, $simplex = null, $documentName = null, $postCode = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setDocumentStatusId($documentStatusId)
            ->setDateSent($dateSent)
            ->setColour($colour)
            ->setSimplex($simplex)
            ->setDocumentName($documentName)
            ->setPostCode($postCode);
    }
    /**
     * Get DocumentId value
     * @return int
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param int $documentId
     * @return \\pestopancake\viapost-php\StructType\DocumentHistory
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: int
        if (!is_null($documentId) && !(is_int($documentId) || ctype_digit($documentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get DocumentStatusId value
     * @return int
     */
    public function getDocumentStatusId()
    {
        return $this->DocumentStatusId;
    }
    /**
     * Set DocumentStatusId value
     * @param int $documentStatusId
     * @return \\pestopancake\viapost-php\StructType\DocumentHistory
     */
    public function setDocumentStatusId($documentStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($documentStatusId) && !(is_int($documentStatusId) || ctype_digit($documentStatusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentStatusId, true), gettype($documentStatusId)), __LINE__);
        }
        $this->DocumentStatusId = $documentStatusId;
        return $this;
    }
    /**
     * Get DateSent value
     * @return string
     */
    public function getDateSent()
    {
        return $this->DateSent;
    }
    /**
     * Set DateSent value
     * @param string $dateSent
     * @return \\pestopancake\viapost-php\StructType\DocumentHistory
     */
    public function setDateSent($dateSent = null)
    {
        // validation for constraint: string
        if (!is_null($dateSent) && !is_string($dateSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateSent, true), gettype($dateSent)), __LINE__);
        }
        $this->DateSent = $dateSent;
        return $this;
    }
    /**
     * Get Colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->Colour;
    }
    /**
     * Set Colour value
     * @param bool $colour
     * @return \\pestopancake\viapost-php\StructType\DocumentHistory
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->Colour = $colour;
        return $this;
    }
    /**
     * Get Simplex value
     * @return bool
     */
    public function getSimplex()
    {
        return $this->Simplex;
    }
    /**
     * Set Simplex value
     * @param bool $simplex
     * @return \\pestopancake\viapost-php\StructType\DocumentHistory
     */
    public function setSimplex($simplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplex) && !is_bool($simplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplex, true), gettype($simplex)), __LINE__);
        }
        $this->Simplex = $simplex;
        return $this;
    }
    /**
     * Get DocumentName value
     * @return string|null
     */
    public function getDocumentName()
    {
        return $this->DocumentName;
    }
    /**
     * Set DocumentName value
     * @param string $documentName
     * @return \\pestopancake\viapost-php\StructType\DocumentHistory
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        $this->DocumentName = $documentName;
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \\pestopancake\viapost-php\StructType\DocumentHistory
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->PostCode = $postCode;
        return $this;
    }
}
