<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.viapost.com/viapostcustomer.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.viapost.com/viapostcustomer.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \\pestopancake\viapost-php\ClassMap::get(),
);
/**
 * Samples for Service ServiceType
 */
$service = new \\pestopancake\viapost-php\ServiceType\Service($options);
/**
 * Sample call for GetSystemID operation/method
 */
if ($service->GetSystemID(new \\pestopancake\viapost-php\StructType\GetSystemID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetterFromXPS operation/method
 */
if ($service->CreateLetterFromXPS(new \\pestopancake\viapost-php\StructType\CreateLetterFromXPS()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentPageCountRange operation/method
 */
if ($service->GetDocumentPageCountRange(new \\pestopancake\viapost-php\StructType\GetDocumentPageCountRange()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendDriverMailingConfirmation operation/method
 */
if ($service->SendDriverMailingConfirmation(new \\pestopancake\viapost-php\StructType\SendDriverMailingConfirmation()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryInserts operation/method
 */
if ($service->GetLibraryInserts(new \\pestopancake\viapost-php\StructType\GetLibraryInserts()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCostCentres operation/method
 */
if ($service->GetCostCentres(new \\pestopancake\viapost-php\StructType\GetCostCentres()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameAndMergeFields operation/method
 */
if ($service->GenerateMappingWithDefaultNameAndMergeFields(new \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFields()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithID operation/method
 */
if ($service->GenerateMappingWithID(new \\pestopancake\viapost-php\StructType\GenerateMappingWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameWithID operation/method
 */
if ($service->GenerateMappingWithDefaultNameWithID(new \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameAndMergeFieldsWithID
 * operation/method
 */
if ($service->GenerateMappingWithDefaultNameAndMergeFieldsWithID(new \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAttachment operation/method
 */
if ($service->CreateAttachment(new \\pestopancake\viapost-php\StructType\CreateAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetterhead operation/method
 */
if ($service->CreateLetterhead(new \\pestopancake\viapost-php\StructType\CreateLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetter operation/method
 */
if ($service->CreateLetter(new \\pestopancake\viapost-php\StructType\CreateLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateMailPack operation/method
 */
if ($service->CreateMailPack(new \\pestopancake\viapost-php\StructType\CreateMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMailPack operation/method
 */
if ($service->DeleteMailPack(new \\pestopancake\viapost-php\StructType\DeleteMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPack operation/method
 */
if ($service->SendMailPack(new \\pestopancake\viapost-php\StructType\SendMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToFindNearest operation/method
 */
if ($service->SendMailPackToFindNearest(new \\pestopancake\viapost-php\StructType\SendMailPackToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPack operation/method
 */
if ($service->CreateAndSendMailPack(new \\pestopancake\viapost-php\StructType\CreateAndSendMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToSingleAddress2 operation/method
 */
if ($service->SendMailPackToSingleAddress2(new \\pestopancake\viapost-php\StructType\SendMailPackToSingleAddress2()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToSingleAddress operation/method
 */
if ($service->SendMailPackToSingleAddress(new \\pestopancake\viapost-php\StructType\SendMailPackToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPackToSingleAddress operation/method
 */
if ($service->CreateAndSendMailPackToSingleAddress(new \\pestopancake\viapost-php\StructType\CreateAndSendMailPackToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailing operation/method
 */
if ($service->SendSimpleMailing(new \\pestopancake\viapost-php\StructType\SendSimpleMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailingToFindNearest operation/method
 */
if ($service->SendSimpleMailingToFindNearest(new \\pestopancake\viapost-php\StructType\SendSimpleMailingToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailingToFindNearest operation/method
 */
if ($service->CreateAndSendSimpleMailingToFindNearest(new \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailingToSingleAddress operation/method
 */
if ($service->SendSimpleMailingToSingleAddress(new \\pestopancake\viapost-php\StructType\SendSimpleMailingToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailing operation/method
 */
if ($service->CreateAndSendSimpleMailing(new \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailingToSingleAddress operation/method
 */
if ($service->CreateAndSendSimpleMailingToSingleAddress(new \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPackToFindNearest operation/method
 */
if ($service->CreateAndSendMailPackToFindNearest(new \\pestopancake\viapost-php\StructType\CreateAndSendMailPackToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddExcludedAddress operation/method
 */
if ($service->AddExcludedAddress(new \\pestopancake\viapost-php\StructType\AddExcludedAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetExcludedAddresses operation/method
 */
if ($service->GetExcludedAddresses(new \\pestopancake\viapost-php\StructType\GetExcludedAddresses()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteExcludedAddressByID operation/method
 */
if ($service->DeleteExcludedAddressByID(new \\pestopancake\viapost-php\StructType\DeleteExcludedAddressByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for FindNearestQueryAddress operation/method
 */
if ($service->FindNearestQueryAddress(new \\pestopancake\viapost-php\StructType\FindNearestQueryAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for FindNearestExecuteSearch operation/method
 */
if ($service->FindNearestExecuteSearch(new \\pestopancake\viapost-php\StructType\FindNearestExecuteSearch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateLetter operation/method
 */
if ($service->UpdateLetter(new \\pestopancake\viapost-php\StructType\UpdateLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateMailPackLetter operation/method
 */
if ($service->UpdateMailPackLetter(new \\pestopancake\viapost-php\StructType\UpdateMailPackLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateMailPackTemplate operation/method
 */
if ($service->UpdateMailPackTemplate(new \\pestopancake\viapost-php\StructType\UpdateMailPackTemplate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailPacks operation/method
 */
if ($service->GetMailPacks(new \\pestopancake\viapost-php\StructType\GetMailPacks()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryMailPacks operation/method
 */
if ($service->GetLibraryMailPacks(new \\pestopancake\viapost-php\StructType\GetLibraryMailPacks()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreatePostcard operation/method
 */
if ($service->CreatePostcard(new \\pestopancake\viapost-php\StructType\CreatePostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryPostcards operation/method
 */
if ($service->GetLibraryPostcards(new \\pestopancake\viapost-php\StructType\GetLibraryPostcards()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryPostcard operation/method
 */
if ($service->PreviewLibraryPostcard(new \\pestopancake\viapost-php\StructType\PreviewLibraryPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcardToSingleAddress operation/method
 */
if ($service->SendPostcardToSingleAddress(new \\pestopancake\viapost-php\StructType\SendPostcardToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcard operation/method
 */
if ($service->SendPostcard(new \\pestopancake\viapost-php\StructType\SendPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcardToFindNearest operation/method
 */
if ($service->SendPostcardToFindNearest(new \\pestopancake\viapost-php\StructType\SendPostcardToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcardToSingleAddress operation/method
 */
if ($service->CreateAndSendPostcardToSingleAddress(new \\pestopancake\viapost-php\StructType\CreateAndSendPostcardToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcard operation/method
 */
if ($service->CreateAndSendPostcard(new \\pestopancake\viapost-php\StructType\CreateAndSendPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcardToFindNearest operation/method
 */
if ($service->CreateAndSendPostcardToFindNearest(new \\pestopancake\viapost-php\StructType\CreateAndSendPostcardToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfSingleAddressMailing operation/method
 */
if ($service->CalculateCostOfSingleAddressMailing(new \\pestopancake\viapost-php\StructType\CalculateCostOfSingleAddressMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfMailing operation/method
 */
if ($service->CalculateCostOfMailing(new \\pestopancake\viapost-php\StructType\CalculateCostOfMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfFindNearestMailing operation/method
 */
if ($service->CalculateCostOfFindNearestMailing(new \\pestopancake\viapost-php\StructType\CalculateCostOfFindNearestMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryLetterheads operation/method
 */
if ($service->GetLibraryLetterheads(new \\pestopancake\viapost-php\StructType\GetLibraryLetterheads()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryAttachments operation/method
 */
if ($service->GetLibraryAttachments(new \\pestopancake\viapost-php\StructType\GetLibraryAttachments()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryLetterhead operation/method
 */
if ($service->PreviewLibraryLetterhead(new \\pestopancake\viapost-php\StructType\PreviewLibraryLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryAttachment operation/method
 */
if ($service->PreviewLibraryAttachment(new \\pestopancake\viapost-php\StructType\PreviewLibraryAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentSingleAddress operation/method
 */
if ($service->PreviewDocumentSingleAddress(new \\pestopancake\viapost-php\StructType\PreviewDocumentSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentMailingList operation/method
 */
if ($service->PreviewDocumentMailingList(new \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentFindNearest operation/method
 */
if ($service->PreviewDocumentFindNearest(new \\pestopancake\viapost-php\StructType\PreviewDocumentFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryMappings operation/method
 */
if ($service->GetLibraryMappings(new \\pestopancake\viapost-php\StructType\GetLibraryMappings()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDataListUrl operation/method
 */
if ($service->GetDataListUrl(new \\pestopancake\viapost-php\StructType\GetDataListUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DownloadDataList operation/method
 */
if ($service->DownloadDataList(new \\pestopancake\viapost-php\StructType\DownloadDataList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDataLists operation/method
 */
if ($service->GetDataLists(new \\pestopancake\viapost-php\StructType\GetDataLists()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfDataList operation/method
 */
if ($service->CalculateCostOfDataList(new \\pestopancake\viapost-php\StructType\CalculateCostOfDataList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserVariables operation/method
 */
if ($service->GetUserVariables(new \\pestopancake\viapost-php\StructType\GetUserVariables()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentation operation/method
 */
if ($service->GetDocumentation(new \\pestopancake\viapost-php\StructType\GetDocumentation()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailHistoryJobs operation/method
 */
if ($service->GetMailHistoryJobs(new \\pestopancake\viapost-php\StructType\GetMailHistoryJobs()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailHistoryDocumentsByJobId operation/method
 */
if ($service->GetMailHistoryDocumentsByJobId(new \\pestopancake\viapost-php\StructType\GetMailHistoryDocumentsByJobId()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RetryLetter operation/method
 */
if ($service->RetryLetter(new \\pestopancake\viapost-php\StructType\RetryLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAddressesForPostcode operation/method
 */
if ($service->GetAddressesForPostcode(new \\pestopancake\viapost-php\StructType\GetAddressesForPostcode()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentStickerArea operation/method
 */
if ($service->GetDocumentStickerArea(new \\pestopancake\viapost-php\StructType\GetDocumentStickerArea()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentReservedAreas operation/method
 */
if ($service->GetDocumentReservedAreas(new \\pestopancake\viapost-php\StructType\GetDocumentReservedAreas()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfNewMailing operation/method
 */
if ($service->CalculateCostOfNewMailing(new \\pestopancake\viapost-php\StructType\CalculateCostOfNewMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for IsFirstClassAvailable operation/method
 */
if ($service->IsFirstClassAvailable(new \\pestopancake\viapost-php\StructType\IsFirstClassAvailable()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserDetails operation/method
 */
if ($service->GetUserDetails(new \\pestopancake\viapost-php\StructType\GetUserDetails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for IsValidLoginToken operation/method
 */
if ($service->IsValidLoginToken(new \\pestopancake\viapost-php\StructType\IsValidLoginToken()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ChangePassword operation/method
 */
if ($service->ChangePassword(new \\pestopancake\viapost-php\StructType\ChangePassword()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLatestVersionDetails operation/method
 */
if ($service->GetLatestVersionDetails(new \\pestopancake\viapost-php\StructType\GetLatestVersionDetails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAccountUrl operation/method
 */
if ($service->GetAccountUrl(new \\pestopancake\viapost-php\StructType\GetAccountUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetPortalUrl operation/method
 */
if ($service->GetPortalUrl(new \\pestopancake\viapost-php\StructType\GetPortalUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLetter operation/method
 */
if ($service->PreviewLetter(new \\pestopancake\viapost-php\StructType\PreviewLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryLetter operation/method
 */
if ($service->PreviewLibraryLetter(new \\pestopancake\viapost-php\StructType\PreviewLibraryLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewMailPack operation/method
 */
if ($service->PreviewMailPack(new \\pestopancake\viapost-php\StructType\PreviewMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SignIn operation/method
 */
if ($service->SignIn(new \\pestopancake\viapost-php\StructType\SignIn()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadDocument operation/method
 */
if ($service->UploadDocument(new \\pestopancake\viapost-php\StructType\UploadDocument()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SearchAddress operation/method
 */
if ($service->SearchAddress(new \\pestopancake\viapost-php\StructType\SearchAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateJobRunRecord operation/method
 */
if ($service->CreateJobRunRecord(new \\pestopancake\viapost-php\StructType\CreateJobRunRecord()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetterWithStructuredAddress operation/method
 */
if ($service->SendLetterWithStructuredAddress(new \\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetterWithStructuredAddressAndExceptions operation/method
 */
if ($service->SendLetterWithStructuredAddressAndExceptions(new \\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddressAndExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetter operation/method
 */
if ($service->SendLetter(new \\pestopancake\viapost-php\StructType\SendLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetBalance operation/method
 */
if ($service->GetBalance(new \\pestopancake\viapost-php\StructType\GetBalance()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAvailableFunds operation/method
 */
if ($service->GetAvailableFunds(new \\pestopancake\viapost-php\StructType\GetAvailableFunds()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterByID operation/method
 */
if ($service->GetLetterByID(new \\pestopancake\viapost-php\StructType\GetLetterByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetters operation/method
 */
if ($service->GetLetters(new \\pestopancake\viapost-php\StructType\GetLetters()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryLetters operation/method
 */
if ($service->GetLibraryLetters(new \\pestopancake\viapost-php\StructType\GetLibraryLetters()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailingLists operation/method
 */
if ($service->GetMailingLists(new \\pestopancake\viapost-php\StructType\GetMailingLists()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailingListByID operation/method
 */
if ($service->GetMailingListByID(new \\pestopancake\viapost-php\StructType\GetMailingListByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMailingList operation/method
 */
if ($service->DeleteMailingList(new \\pestopancake\viapost-php\StructType\DeleteMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMapping operation/method
 */
if ($service->DeleteMapping(new \\pestopancake\viapost-php\StructType\DeleteMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteUserVariable operation/method
 */
if ($service->DeleteUserVariable(new \\pestopancake\viapost-php\StructType\DeleteUserVariable()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterhead operation/method
 */
if ($service->DeleteLetterhead(new \\pestopancake\viapost-php\StructType\DeleteLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetter operation/method
 */
if ($service->DeleteLetter(new \\pestopancake\viapost-php\StructType\DeleteLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteAttachment operation/method
 */
if ($service->DeleteAttachment(new \\pestopancake\viapost-php\StructType\DeleteAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeletePostcard operation/method
 */
if ($service->DeletePostcard(new \\pestopancake\viapost-php\StructType\DeletePostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingList operation/method
 */
if ($service->UploadMailingList(new \\pestopancake\viapost-php\StructType\UploadMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingListWithMapping operation/method
 */
if ($service->UploadMailingListWithMapping(new \\pestopancake\viapost-php\StructType\UploadMailingListWithMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingListWithMappingAndShare operation/method
 */
if ($service->UploadMailingListWithMappingAndShare(new \\pestopancake\viapost-php\StructType\UploadMailingListWithMappingAndShare()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadConsolidatedPDF operation/method
 */
if ($service->UploadConsolidatedPDF(new \\pestopancake\viapost-php\StructType\UploadConsolidatedPDF()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMerge operation/method
 */
if ($service->MailMerge(new \\pestopancake\viapost-php\StructType\MailMerge()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMergeWithExceptionsAndConfirmationEmails operation/method
 */
if ($service->MailMergeWithExceptionsAndConfirmationEmails(new \\pestopancake\viapost-php\StructType\MailMergeWithExceptionsAndConfirmationEmails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMergeWithExceptions operation/method
 */
if ($service->MailMergeWithExceptions(new \\pestopancake\viapost-php\StructType\MailMergeWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAccount operation/method
 */
if ($service->CreateAccount(new \\pestopancake\viapost-php\StructType\CreateAccount()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAccountNonUK operation/method
 */
if ($service->CreateAccountNonUK(new \\pestopancake\viapost-php\StructType\CreateAccountNonUK()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccount operation/method
 */
if ($service->AddUserToAccount(new \\pestopancake\viapost-php\StructType\AddUserToAccount()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountPermissions operation/method
 */
if ($service->AddUserToAccountPermissions(new \\pestopancake\viapost-php\StructType\AddUserToAccountPermissions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountNonUK operation/method
 */
if ($service->AddUserToAccountNonUK(new \\pestopancake\viapost-php\StructType\AddUserToAccountNonUK()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountNonUKPermissions operation/method
 */
if ($service->AddUserToAccountNonUKPermissions(new \\pestopancake\viapost-php\StructType\AddUserToAccountNonUKPermissions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostComplexBatchWithExceptions operation/method
 */
if ($service->CalculateLetterCostComplexBatchWithExceptions(new \\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatchWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostSimpleBatch operation/method
 */
if ($service->CalculateLetterCostSimpleBatch(new \\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostSimpleBatchWithExceptions operation/method
 */
if ($service->CalculateLetterCostSimpleBatchWithExceptions(new \\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatchWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostComplexBatch operation/method
 */
if ($service->CalculateLetterCostComplexBatch(new \\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateMailMergeCost operation/method
 */
if ($service->CalculateMailMergeCost(new \\pestopancake\viapost-php\StructType\CalculateMailMergeCost()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateEstimatedDeliveryDate operation/method
 */
if ($service->CalculateEstimatedDeliveryDate(new \\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateEstimatedDeliveryDateNow operation/method
 */
if ($service->CalculateEstimatedDeliveryDateNow(new \\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDateNow()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateSendDateForDeliveryDate operation/method
 */
if ($service->CalculateSendDateForDeliveryDate(new \\pestopancake\viapost-php\StructType\CalculateSendDateForDeliveryDate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterStatusByLetterID operation/method
 */
if ($service->GetLetterStatusByLetterID(new \\pestopancake\viapost-php\StructType\GetLetterStatusByLetterID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterStatusByCustomerAPILetter operation/method
 */
if ($service->GetLetterStatusByCustomerAPILetter(new \\pestopancake\viapost-php\StructType\GetLetterStatusByCustomerAPILetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterByLetterID operation/method
 */
if ($service->DeleteLetterByLetterID(new \\pestopancake\viapost-php\StructType\DeleteLetterByLetterID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterByCustomerAPILetter operation/method
 */
if ($service->DeleteLetterByCustomerAPILetter(new \\pestopancake\viapost-php\StructType\DeleteLetterByCustomerAPILetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreatePriceBand operation/method
 */
if ($service->CreatePriceBand(new \\pestopancake\viapost-php\StructType\CreatePriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AssignPriceBand operation/method
 */
if ($service->AssignPriceBand(new \\pestopancake\viapost-php\StructType\AssignPriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetPriceBands operation/method
 */
if ($service->GetPriceBands(new \\pestopancake\viapost-php\StructType\GetPriceBands()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeletePriceBand operation/method
 */
if ($service->DeletePriceBand(new \\pestopancake\viapost-php\StructType\DeletePriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCountries operation/method
 */
if ($service->GetCountries(new \\pestopancake\viapost-php\StructType\GetCountries()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DisableUser operation/method
 */
if ($service->DisableUser(new \\pestopancake\viapost-php\StructType\DisableUser()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMessage operation/method
 */
if ($service->GetMessage(new \\pestopancake\viapost-php\StructType\GetMessage()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMapping operation/method
 */
if ($service->GenerateMapping(new \\pestopancake\viapost-php\StructType\GenerateMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultName operation/method
 */
if ($service->GenerateMappingWithDefaultName(new \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultName()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
