<?php

namespace \pestopancake\viapost-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerAPIMailingList StructType
 * @subpackage Structs
 */
class CustomerAPIMailingList extends AbstractStructBase
{
    /**
     * The NumberOfAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfAddresses;
    /**
     * The DateLastUsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateLastUsed;
    /**
     * The MailingListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailingListID;
    /**
     * The MailingListTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailingListTitle;
    /**
     * Constructor method for CustomerAPIMailingList
     * @uses CustomerAPIMailingList::setNumberOfAddresses()
     * @uses CustomerAPIMailingList::setDateLastUsed()
     * @uses CustomerAPIMailingList::setMailingListID()
     * @uses CustomerAPIMailingList::setMailingListTitle()
     * @param int $numberOfAddresses
     * @param string $dateLastUsed
     * @param string $mailingListID
     * @param string $mailingListTitle
     */
    public function __construct($numberOfAddresses = null, $dateLastUsed = null, $mailingListID = null, $mailingListTitle = null)
    {
        $this
            ->setNumberOfAddresses($numberOfAddresses)
            ->setDateLastUsed($dateLastUsed)
            ->setMailingListID($mailingListID)
            ->setMailingListTitle($mailingListTitle);
    }
    /**
     * Get NumberOfAddresses value
     * @return int
     */
    public function getNumberOfAddresses()
    {
        return $this->NumberOfAddresses;
    }
    /**
     * Set NumberOfAddresses value
     * @param int $numberOfAddresses
     * @return \\pestopancake\viapost-php\StructType\CustomerAPIMailingList
     */
    public function setNumberOfAddresses($numberOfAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddresses) && !(is_int($numberOfAddresses) || ctype_digit($numberOfAddresses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddresses, true), gettype($numberOfAddresses)), __LINE__);
        }
        $this->NumberOfAddresses = $numberOfAddresses;
        return $this;
    }
    /**
     * Get DateLastUsed value
     * @return string
     */
    public function getDateLastUsed()
    {
        return $this->DateLastUsed;
    }
    /**
     * Set DateLastUsed value
     * @param string $dateLastUsed
     * @return \\pestopancake\viapost-php\StructType\CustomerAPIMailingList
     */
    public function setDateLastUsed($dateLastUsed = null)
    {
        // validation for constraint: string
        if (!is_null($dateLastUsed) && !is_string($dateLastUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateLastUsed, true), gettype($dateLastUsed)), __LINE__);
        }
        $this->DateLastUsed = $dateLastUsed;
        return $this;
    }
    /**
     * Get MailingListID value
     * @return string|null
     */
    public function getMailingListID()
    {
        return $this->MailingListID;
    }
    /**
     * Set MailingListID value
     * @param string $mailingListID
     * @return \\pestopancake\viapost-php\StructType\CustomerAPIMailingList
     */
    public function setMailingListID($mailingListID = null)
    {
        // validation for constraint: string
        if (!is_null($mailingListID) && !is_string($mailingListID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingListID, true), gettype($mailingListID)), __LINE__);
        }
        $this->MailingListID = $mailingListID;
        return $this;
    }
    /**
     * Get MailingListTitle value
     * @return string|null
     */
    public function getMailingListTitle()
    {
        return $this->MailingListTitle;
    }
    /**
     * Set MailingListTitle value
     * @param string $mailingListTitle
     * @return \\pestopancake\viapost-php\StructType\CustomerAPIMailingList
     */
    public function setMailingListTitle($mailingListTitle = null)
    {
        // validation for constraint: string
        if (!is_null($mailingListTitle) && !is_string($mailingListTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingListTitle, true), gettype($mailingListTitle)), __LINE__);
        }
        $this->MailingListTitle = $mailingListTitle;
        return $this;
    }
}
