<?php

namespace \pestopancake\viapost-php\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSystemID
     * Meta information extracted from the WSDL
     * - documentation: Return a string containing the system identifier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetSystemID $parameters
     * @return \\pestopancake\viapost-php\StructType\GetSystemIDResponse|bool
     */
    public function GetSystemID(\\pestopancake\viapost-php\StructType\GetSystemID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSystemID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLetterFromXPS
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letter in XPS format. Letters can be used either in a Mail Pack or in a Simple Mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateLetterFromXPS $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateLetterFromXPSResponse|bool
     */
    public function CreateLetterFromXPS(\\pestopancake\viapost-php\StructType\CreateLetterFromXPS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetterFromXPS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentPageCountRange
     * Meta information extracted from the WSDL
     * - documentation: Returns the minimum and maximum number of pages for a given document type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetDocumentPageCountRange $parameters
     * @return \\pestopancake\viapost-php\StructType\GetDocumentPageCountRangeResponse|bool
     */
    public function GetDocumentPageCountRange(\\pestopancake\viapost-php\StructType\GetDocumentPageCountRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentPageCountRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendDriverMailingConfirmation
     * Meta information extracted from the WSDL
     * - documentation: Internal use only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendDriverMailingConfirmation $parameters
     * @return \\pestopancake\viapost-php\StructType\SendDriverMailingConfirmationResponse|bool
     */
    public function SendDriverMailingConfirmation(\\pestopancake\viapost-php\StructType\SendDriverMailingConfirmation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDriverMailingConfirmation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryInserts
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's available inserts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLibraryInserts $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLibraryInsertsResponse|bool
     */
    public function GetLibraryInserts(\\pestopancake\viapost-php\StructType\GetLibraryInserts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryInserts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCostCentres
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the cost centres defined for this user/customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetCostCentres $parameters
     * @return \\pestopancake\viapost-php\StructType\GetCostCentresResponse|bool
     */
    public function GetCostCentres(\\pestopancake\viapost-php\StructType\GetCostCentres $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCostCentres($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameAndMergeFields
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and merge fields.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFields $parameters
     * @return \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFieldsResponse|bool
     */
    public function GenerateMappingWithDefaultNameAndMergeFields(\\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameAndMergeFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMappingWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GenerateMappingWithID $parameters
     * @return \\pestopancake\viapost-php\StructType\GenerateMappingWithIDResponse|bool
     */
    public function GenerateMappingWithID(\\pestopancake\viapost-php\StructType\GenerateMappingWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameWithID $parameters
     * @return \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameWithIDResponse|bool
     */
    public function GenerateMappingWithDefaultNameWithID(\\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateMappingWithDefaultNameAndMergeFieldsWithID
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name and merge fields and get the ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithID $parameters
     * @return \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithIDResponse|bool
     */
    public function GenerateMappingWithDefaultNameAndMergeFieldsWithID(\\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultNameAndMergeFieldsWithID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAttachment
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a PDF attachment which can be attached to a letter when creating a Mail Pack. A number of attachments can be added to a Mail Pack. The attachmentID can be referenced for use with Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAttachment $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAttachmentResponse|bool
     */
    public function CreateAttachment(\\pestopancake\viapost-php\StructType\CreateAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letterhead in PDF format. Letterheads can be used in Mail Packs either on the first page or every page in the Pack. The letterheadID can be referenced for use with Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateLetterhead $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateLetterheadResponse|bool
     */
    public function CreateLetterhead(\\pestopancake\viapost-php\StructType\CreateLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new Letter in either PDF or Word XML (.xml) format. Letters can be used either in a Mail Pack or in a Simple Mailing. Document's uploaded in Word XML (.xml) format can contain Merge Fields which will be
     * replaced when the Mailing is run. The letterID can be referenced for use with Mail Packs or Simple Mailings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateLetter $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateLetterResponse|bool
     */
    public function CreateLetter(\\pestopancake\viapost-php\StructType\CreateLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to Create a Mail Pack, a letterID must be supplied while both attachmentIDs and letterheadID are optional. A Mail Pack will be created which can then be sent to a single address or an address list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateMailPack $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateMailPackResponse|bool
     */
    public function CreateMailPack(\\pestopancake\viapost-php\StructType\CreateMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a Mail Pack using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The mailPackID you supply will be used to delete your Mail Pack. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteMailPack $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteMailPackResponse|bool
     */
    public function DeleteMailPack(\\pestopancake\viapost-php\StructType\DeleteMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a previously saved Mail Pack.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendMailPack $parameters
     * @return \\pestopancake\viapost-php\StructType\SendMailPackResponse|bool
     */
    public function SendMailPack(\\pestopancake\viapost-php\StructType\SendMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a previously saved Mail Pack to a Mailing list created from Find Nearest.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendMailPackToFindNearest $parameters
     * @return \\pestopancake\viapost-php\StructType\SendMailPackToFindNearestResponse|bool
     */
    public function SendMailPackToFindNearest(\\pestopancake\viapost-php\StructType\SendMailPackToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Mailing List. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendMailPack $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendMailPackResponse|bool
     */
    public function CreateAndSendMailPack(\\pestopancake\viapost-php\StructType\CreateAndSendMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToSingleAddress2
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Mail Pack a previously saved MailPack to a Single Address. This will require a Mail Pack ID and single address details. This method is used by the ViaPost Spooler software. SendMailPackToSingleAddress should
     * be used for any API integration.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendMailPackToSingleAddress2 $parameters
     * @return \\pestopancake\viapost-php\StructType\SendMailPackToSingleAddress2Response|bool
     */
    public function SendMailPackToSingleAddress2(\\pestopancake\viapost-php\StructType\SendMailPackToSingleAddress2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToSingleAddress2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Mail Pack a previously saved MailPack to a Single Address. This will require a Mail Pack ID and single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendMailPackToSingleAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\SendMailPackToSingleAddressResponse|bool
     */
    public function SendMailPackToSingleAddress(\\pestopancake\viapost-php\StructType\SendMailPackToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendMailPackToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Single Address. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendMailPackToSingleAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendMailPackToSingleAddressResponse|bool
     */
    public function CreateAndSendMailPackToSingleAddress(\\pestopancake\viapost-php\StructType\CreateAndSendMailPackToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPackToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Simple Mailing. A simple mailing consists of a previosly uploaded letter and an address list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendSimpleMailing $parameters
     * @return \\pestopancake\viapost-php\StructType\SendSimpleMailingResponse|bool
     */
    public function SendSimpleMailing(\\pestopancake\viapost-php\StructType\SendSimpleMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailingToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Simple Mailing to a Mailing list created from Find Nearest. A simple mailing consists of a previosly uploaded letter and address details for a Find Nearest search.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendSimpleMailingToFindNearest $parameters
     * @return \\pestopancake\viapost-php\StructType\SendSimpleMailingToFindNearestResponse|bool
     */
    public function SendSimpleMailingToFindNearest(\\pestopancake\viapost-php\StructType\SendSimpleMailingToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailingToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendSimpleMailingToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a Mailing list created from Find Nearest. A letter in either PDF or Word XML (.xml) must be supplied with addess details for the Find Nearest search.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToFindNearest $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToFindNearestResponse|bool
     */
    public function CreateAndSendSimpleMailingToFindNearest(\\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailingToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailingToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a Single Address. A letter in either PDF or Word XML (.xml) must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendSimpleMailingToSingleAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\SendSimpleMailingToSingleAddressResponse|bool
     */
    public function SendSimpleMailingToSingleAddress(\\pestopancake\viapost-php\StructType\SendSimpleMailingToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailingToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendSimpleMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing. A letter in either PDF or Word XML (.xml) must be supplied with a mailinglistID from a previously uploaded mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailing $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingResponse|bool
     */
    public function CreateAndSendSimpleMailing(\\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendSimpleMailingToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a single address. A letter in either PDF or Word XML (.xml) must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToSingleAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToSingleAddressResponse|bool
     */
    public function CreateAndSendSimpleMailingToSingleAddress(\\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendSimpleMailingToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendMailPackToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Mail Pack to a Mailing list created from Find Nearest. This will require a letterID from a previously uploaded letter, attachmentsID's and letterheadID are optional.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendMailPackToFindNearest $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendMailPackToFindNearestResponse|bool
     */
    public function CreateAndSendMailPackToFindNearest(\\pestopancake\viapost-php\StructType\CreateAndSendMailPackToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendMailPackToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddExcludedAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add an excluded address at either a list, user or company level. For lists you should enter the mailinglistID. Otherwise this should be 0.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\AddExcludedAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\AddExcludedAddressResponse|bool
     */
    public function AddExcludedAddress(\\pestopancake\viapost-php\StructType\AddExcludedAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddExcludedAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExcludedAddresses
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of your excluded address which are currently in use.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetExcludedAddresses $parameters
     * @return \\pestopancake\viapost-php\StructType\GetExcludedAddressesResponse|bool
     */
    public function GetExcludedAddresses(\\pestopancake\viapost-php\StructType\GetExcludedAddresses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExcludedAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteExcludedAddressByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a delete an excluded address - you can get the ID by using the GetExcludedAddresses method
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteExcludedAddressByID $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteExcludedAddressByIDResponse|bool
     */
    public function DeleteExcludedAddressByID(\\pestopancake\viapost-php\StructType\DeleteExcludedAddressByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteExcludedAddressByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindNearestQueryAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to query a FindNearest search. This method will not create a Find Nearest list but will return the cost of the list including how many addresses were found. Use the FindNearestExecuteSearch method to create a mailing
     * list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\FindNearestQueryAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\FindNearestQueryAddressResponse|bool
     */
    public function FindNearestQueryAddress(\\pestopancake\viapost-php\StructType\FindNearestQueryAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindNearestQueryAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindNearestExecuteSearch
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a FindNearest List. The resulting list will contain all addresses within a radius or range surrounding the search address provided. This list can then be used when sending Simple Mailings or Mail Packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\FindNearestExecuteSearch $parameters
     * @return \\pestopancake\viapost-php\StructType\FindNearestExecuteSearchResponse|bool
     */
    public function FindNearestExecuteSearch(\\pestopancake\viapost-php\StructType\FindNearestExecuteSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindNearestExecuteSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to edit an existing letter. The new ID will be returned and all references to the letter will be updated.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\UpdateLetter $parameters
     * @return \\pestopancake\viapost-php\StructType\UpdateLetterResponse|bool
     */
    public function UpdateLetter(\\pestopancake\viapost-php\StructType\UpdateLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMailPackLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to update a Mail Pack to refer to a different letter.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\UpdateMailPackLetter $parameters
     * @return \\pestopancake\viapost-php\StructType\UpdateMailPackLetterResponse|bool
     */
    public function UpdateMailPackLetter(\\pestopancake\viapost-php\StructType\UpdateMailPackLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateMailPackLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMailPackTemplate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to update a Mail Pack to refer to a different template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\UpdateMailPackTemplate $parameters
     * @return \\pestopancake\viapost-php\StructType\UpdateMailPackTemplateResponse|bool
     */
    public function UpdateMailPackTemplate(\\pestopancake\viapost-php\StructType\UpdateMailPackTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateMailPackTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailPacks
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to get a list of available MailPacks. The list is returned as a pipe-delimited string with the newest MailPacks first.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetMailPacks $parameters
     * @return \\pestopancake\viapost-php\StructType\GetMailPacksResponse|bool
     */
    public function GetMailPacks(\\pestopancake\viapost-php\StructType\GetMailPacks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailPacks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryMailPacks
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of available MailPacks. An array of MailPack objects is returned with the newest MailPacks first.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLibraryMailPacks $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLibraryMailPacksResponse|bool
     */
    public function GetLibraryMailPacks(\\pestopancake\viapost-php\StructType\GetLibraryMailPacks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryMailPacks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a new A5 landscape postcard in PDF format. A postcard can be defined by two pages in a single PDF or the first page of two PDFs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreatePostcard $parameters
     * @return \\pestopancake\viapost-php\StructType\CreatePostcardResponse|bool
     */
    public function CreatePostcard(\\pestopancake\viapost-php\StructType\CreatePostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryPostcards
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's postcards that have been uploaded via the portal or the CreatePostcard API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLibraryPostcards $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLibraryPostcardsResponse|bool
     */
    public function GetLibraryPostcards(\\pestopancake\viapost-php\StructType\GetLibraryPostcards $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryPostcards($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryPostcard
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the postcard which was uploaded via the portal or the CreatePostcard API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewLibraryPostcard $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewLibraryPostcardResponse|bool
     */
    public function PreviewLibraryPostcard(\\pestopancake\viapost-php\StructType\PreviewLibraryPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcardToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendPostcardToSingleAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\SendPostcardToSingleAddressResponse|bool
     */
    public function SendPostcardToSingleAddress(\\pestopancake\viapost-php\StructType\SendPostcardToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcardToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendPostcard $parameters
     * @return \\pestopancake\viapost-php\StructType\SendPostcardResponse|bool
     */
    public function SendPostcard(\\pestopancake\viapost-php\StructType\SendPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcardToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendPostcardToFindNearest $parameters
     * @return \\pestopancake\viapost-php\StructType\SendPostcardToFindNearestResponse|bool
     */
    public function SendPostcardToFindNearest(\\pestopancake\viapost-php\StructType\SendPostcardToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcardToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateAndSendPostcardToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a single address. An A5 landscape postcard in PDF format must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendPostcardToSingleAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendPostcardToSingleAddressResponse|bool
     */
    public function CreateAndSendPostcardToSingleAddress(\\pestopancake\viapost-php\StructType\CreateAndSendPostcardToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcardToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendPostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a mailing list. An A5 landscape postcard in PDF format must be supplied with the mailing list ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendPostcard $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendPostcardResponse|bool
     */
    public function CreateAndSendPostcard(\\pestopancake\viapost-php\StructType\CreateAndSendPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAndSendPostcardToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a postcard to a mailing list created from a find nearest request. An A5 landscape postcard in PDF format must be supplied with the find nearest request details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAndSendPostcardToFindNearest $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAndSendPostcardToFindNearestResponse|bool
     */
    public function CreateAndSendPostcardToFindNearest(\\pestopancake\viapost-php\StructType\CreateAndSendPostcardToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAndSendPostcardToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CalculateCostOfSingleAddressMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateCostOfSingleAddressMailing $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateCostOfSingleAddressMailingResponse|bool
     */
    public function CalculateCostOfSingleAddressMailing(\\pestopancake\viapost-php\StructType\CalculateCostOfSingleAddressMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfSingleAddressMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateCostOfMailing $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateCostOfMailingResponse|bool
     */
    public function CalculateCostOfMailing(\\pestopancake\viapost-php\StructType\CalculateCostOfMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfFindNearestMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of sending a letter (simple mailing), Mail Pack or postcard to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateCostOfFindNearestMailing $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateCostOfFindNearestMailingResponse|bool
     */
    public function CalculateCostOfFindNearestMailing(\\pestopancake\viapost-php\StructType\CalculateCostOfFindNearestMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfFindNearestMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryLetterheads
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's letterheads that have been uploaded via the portal or the CreateLetterhead API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLibraryLetterheads $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLibraryLetterheadsResponse|bool
     */
    public function GetLibraryLetterheads(\\pestopancake\viapost-php\StructType\GetLibraryLetterheads $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryLetterheads($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryAttachments
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's attachments that have been uploaded via the portal or the CreateAttachment API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLibraryAttachments $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLibraryAttachmentsResponse|bool
     */
    public function GetLibraryAttachments(\\pestopancake\viapost-php\StructType\GetLibraryAttachments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryAttachments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the letterhead which was uploaded via the portal or the CreateLetterhead API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewLibraryLetterhead $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewLibraryLetterheadResponse|bool
     */
    public function PreviewLibraryLetterhead(\\pestopancake\viapost-php\StructType\PreviewLibraryLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryAttachment
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the attachment which was uploaded via the portal or the CreateAttachment API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewLibraryAttachment $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewLibraryAttachmentResponse|bool
     */
    public function PreviewLibraryAttachment(\\pestopancake\viapost-php\StructType\PreviewLibraryAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewDocumentSingleAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentSingleAddressResponse|bool
     */
    public function PreviewDocumentSingleAddress(\\pestopancake\viapost-php\StructType\PreviewDocumentSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentMailingList
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewDocumentMailingList $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentMailingListResponse|bool
     */
    public function PreviewDocumentMailingList(\\pestopancake\viapost-php\StructType\PreviewDocumentMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewDocumentFindNearest $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewDocumentFindNearestResponse|bool
     */
    public function PreviewDocumentFindNearest(\\pestopancake\viapost-php\StructType\PreviewDocumentFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryMappings
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's address list mappings that have been uploaded via the portal or the various GenerateMapping API methods.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLibraryMappings $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLibraryMappingsResponse|bool
     */
    public function GetLibraryMappings(\\pestopancake\viapost-php\StructType\GetLibraryMappings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryMappings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataListUrl
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve the URL of a specified data list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetDataListUrl $parameters
     * @return \\pestopancake\viapost-php\StructType\GetDataListUrlResponse|bool
     */
    public function GetDataListUrl(\\pestopancake\viapost-php\StructType\GetDataListUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataListUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DownloadDataList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to download a specified data list as a CSV file. Note that not all data lists are permitted to be downloaded.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DownloadDataList $parameters
     * @return \\pestopancake\viapost-php\StructType\DownloadDataListResponse|bool
     */
    public function DownloadDataList(\\pestopancake\viapost-php\StructType\DownloadDataList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DownloadDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataLists
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's data lists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetDataLists $parameters
     * @return \\pestopancake\viapost-php\StructType\GetDataListsResponse|bool
     */
    public function GetDataLists(\\pestopancake\viapost-php\StructType\GetDataLists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfDataList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the cost of purchasing a data list containing a given number of items.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateCostOfDataList $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateCostOfDataListResponse|bool
     */
    public function CalculateCostOfDataList(\\pestopancake\viapost-php\StructType\CalculateCostOfDataList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserVariables
     * Meta information extracted from the WSDL
     * - documentation: This method returns a list of variables, similar to the functionality of the Merge Fields page within the Portal. The variable name and value are returned.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetUserVariables $parameters
     * @return \\pestopancake\viapost-php\StructType\GetUserVariablesResponse|bool
     */
    public function GetUserVariables(\\pestopancake\viapost-php\StructType\GetUserVariables $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserVariables($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentation
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of documentation urls such as the letter guidance template. A description and url is returned for each url.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetDocumentation $parameters
     * @return \\pestopancake\viapost-php\StructType\GetDocumentationResponse|bool
     */
    public function GetDocumentation(\\pestopancake\viapost-php\StructType\GetDocumentation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailHistoryJobs
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of jobs. The method returns similar data to the Mail History page within the Portal.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetMailHistoryJobs $parameters
     * @return \\pestopancake\viapost-php\StructType\GetMailHistoryJobsResponse|bool
     */
    public function GetMailHistoryJobs(\\pestopancake\viapost-php\StructType\GetMailHistoryJobs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailHistoryJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailHistoryDocumentsByJobId
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of documents for a particular job. The method returns similar data to the page that is displayed within the Portal when you click on a particular job and it lists the documents.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetMailHistoryDocumentsByJobId $parameters
     * @return \\pestopancake\viapost-php\StructType\GetMailHistoryDocumentsByJobIdResponse|bool
     */
    public function GetMailHistoryDocumentsByJobId(\\pestopancake\viapost-php\StructType\GetMailHistoryDocumentsByJobId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailHistoryDocumentsByJobId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetryLetter
     * Meta information extracted from the WSDL
     * - documentation: Retry sending a letter which couldn't previously be sent.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\RetryLetter $parameters
     * @return \\pestopancake\viapost-php\StructType\RetryLetterResponse|bool
     */
    public function RetryLetter(\\pestopancake\viapost-php\StructType\RetryLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetryLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAddressesForPostcode
     * Meta information extracted from the WSDL
     * - documentation: Return a list of addresses belonging to the specified postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetAddressesForPostcode $parameters
     * @return \\pestopancake\viapost-php\StructType\GetAddressesForPostcodeResponse|bool
     */
    public function GetAddressesForPostcode(\\pestopancake\viapost-php\StructType\GetAddressesForPostcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAddressesForPostcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentStickerArea
     * Meta information extracted from the WSDL
     * - documentation: Get the dimensions of the address sticker in pixels. Can be used for letters or postcards.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetDocumentStickerArea $parameters
     * @return \\pestopancake\viapost-php\StructType\GetDocumentStickerAreaResponse|bool
     */
    public function GetDocumentStickerArea(\\pestopancake\viapost-php\StructType\GetDocumentStickerArea $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentStickerArea($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentReservedAreas
     * Meta information extracted from the WSDL
     * - documentation: Get the reserved areas for a particular document type. Can be used for letters or postcards.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetDocumentReservedAreas $parameters
     * @return \\pestopancake\viapost-php\StructType\GetDocumentReservedAreasResponse|bool
     */
    public function GetDocumentReservedAreas(\\pestopancake\viapost-php\StructType\GetDocumentReservedAreas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentReservedAreas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateCostOfNewMailing
     * Meta information extracted from the WSDL
     * - documentation: Calculate the cost of sending a letter or postcard not yet uploaded on the system to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateCostOfNewMailing $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateCostOfNewMailingResponse|bool
     */
    public function CalculateCostOfNewMailing(\\pestopancake\viapost-php\StructType\CalculateCostOfNewMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCostOfNewMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsFirstClassAvailable
     * Meta information extracted from the WSDL
     * - documentation: Determine if 1st class delivery support is available in addition to the standard 2nd class delivery support.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\IsFirstClassAvailable $parameters
     * @return \\pestopancake\viapost-php\StructType\IsFirstClassAvailableResponse|bool
     */
    public function IsFirstClassAvailable(\\pestopancake\viapost-php\StructType\IsFirstClassAvailable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsFirstClassAvailable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserDetails
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get Baisc User Deta, User Pricing and VatRate.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetUserDetails $parameters
     * @return \\pestopancake\viapost-php\StructType\GetUserDetailsResponse|bool
     */
    public function GetUserDetails(\\pestopancake\viapost-php\StructType\GetUserDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsValidLoginToken
     * Meta information extracted from the WSDL
     * - documentation: Checks whether the supplied login token is valid or not.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\IsValidLoginToken $parameters
     * @return \\pestopancake\viapost-php\StructType\IsValidLoginTokenResponse|bool
     */
    public function IsValidLoginToken(\\pestopancake\viapost-php\StructType\IsValidLoginToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsValidLoginToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangePassword
     * Meta information extracted from the WSDL
     * - documentation: Use this method to change a user's password. You can only change the password of the user that you are logged into the API as.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\ChangePassword $parameters
     * @return \\pestopancake\viapost-php\StructType\ChangePasswordResponse|bool
     */
    public function ChangePassword(\\pestopancake\viapost-php\StructType\ChangePassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLatestVersionDetails
     * Meta information extracted from the WSDL
     * - documentation: Gets the latest version of a specifed client application.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLatestVersionDetails $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLatestVersionDetailsResponse|bool
     */
    public function GetLatestVersionDetails(\\pestopancake\viapost-php\StructType\GetLatestVersionDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLatestVersionDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountUrl
     * Meta information extracted from the WSDL
     * - documentation: Gets a url to the users account page in the portal.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetAccountUrl $parameters
     * @return \\pestopancake\viapost-php\StructType\GetAccountUrlResponse|bool
     */
    public function GetAccountUrl(\\pestopancake\viapost-php\StructType\GetAccountUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPortalUrl
     * Meta information extracted from the WSDL
     * - documentation: Gets a url to the specified portal page.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetPortalUrl $parameters
     * @return \\pestopancake\viapost-php\StructType\GetPortalUrlResponse|bool
     */
    public function GetPortalUrl(\\pestopancake\viapost-php\StructType\GetPortalUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPortalUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLetter
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Gets a byte array that is the PDF letter with the stickered address. Only works for addresses with a valid postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewLetter $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewLetterResponse|bool
     */
    public function PreviewLetter(\\pestopancake\viapost-php\StructType\PreviewLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryLetter
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the letter which was uploaded via the portal or the CreateLetter API method. Letters uploaded via the UploadDocument or UploadConsolidatedPDF API methods are not supported.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewLibraryLetter $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewLibraryLetterResponse|bool
     */
    public function PreviewLibraryLetter(\\pestopancake\viapost-php\StructType\PreviewLibraryLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewMailPack
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the PDF Mail Pack with the stickered address. Only works for addresses with a valid postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\PreviewMailPack $parameters
     * @return \\pestopancake\viapost-php\StructType\PreviewMailPackResponse|bool
     */
    public function PreviewMailPack(\\pestopancake\viapost-php\StructType\PreviewMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SignIn
     * Meta information extracted from the WSDL
     * - documentation: Use this method to sign in to the ViaPost User Webservices. Signing in is mandatory and must be done before any other service methods can be used. You must supply a valid Viapost Username and Password. Returns a LoginToken which must
     * be supplied as a parameter to the other methods. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SignIn $parameters
     * @return \\pestopancake\viapost-php\StructType\SignInResponse|bool
     */
    public function SignIn(\\pestopancake\viapost-php\StructType\SignIn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SignIn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadDocument
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to upload a PDF document. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter Name you supply will be used to display your letter. The DocumentData
     * parameter must contain your PDF as a Base64-encoded byte array. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The LetterID is populated with the new record
     * ID once the letter has been uploaded.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\UploadDocument $parameters
     * @return \\pestopancake\viapost-php\StructType\UploadDocumentResponse|bool
     */
    public function UploadDocument(\\pestopancake\viapost-php\StructType\UploadDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchAddress
     * Meta information extracted from the WSDL
     * - documentation: Passed an address to search for in InputAddress (can be partially complete), returns a list of postal addresses as well as descriptive text (ReturnMessage) and a code (PafCode) for the results of the search. You must supply a valid
     * LoginToken to use this method (use SignIn to acquire a LoginToken). If an address search fails the PafCode and ReturnMessage parameters will have more detail and the list of returned addresses will be empty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SearchAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\SearchAddressResponse|bool
     */
    public function SearchAddress(\\pestopancake\viapost-php\StructType\SearchAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateJobRunRecord
     * Meta information extracted from the WSDL
     * - documentation: Internal use only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateJobRunRecord $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateJobRunRecordResponse|bool
     */
    public function CreateJobRunRecord(\\pestopancake\viapost-php\StructType\CreateJobRunRecord $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateJobRunRecord($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendLetterWithStructuredAddress
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to send a letter using a structured address block (as returned by SearchAddress) and receive detailed information on the address validation if it fails (PafCode and ReturnMessage). You must supply a valid
     * LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddress $parameters
     * @return \\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddressResponse|bool
     */
    public function SendLetterWithStructuredAddress(\\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetterWithStructuredAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SendLetterWithStructuredAddressAndExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] This method is a specialisation of the old SendLetterWithStructuredAddress that allows users force an address i.e. it is not checked against the PAF database. There is additional cost for this option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddressAndExceptions $parameters
     * @return \\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddressAndExceptionsResponse|bool
     */
    public function SendLetterWithStructuredAddressAndExceptions(\\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddressAndExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetterWithStructuredAddressAndExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendLetter
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to send a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. The ReturnMessage
     * provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\SendLetter $parameters
     * @return \\pestopancake\viapost-php\StructType\SendLetterResponse|bool
     */
    public function SendLetter(\\pestopancake\viapost-php\StructType\SendLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBalance
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve your account balance. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. Your account balance
     * is returned in the AccountBalance parameter. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetBalance $parameters
     * @return \\pestopancake\viapost-php\StructType\GetBalanceResponse|bool
     */
    public function GetBalance(\\pestopancake\viapost-php\StructType\GetBalance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableFunds
     * Meta information extracted from the WSDL
     * - documentation: Use this method to determine the available funds on your account, including any possible credit limit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetAvailableFunds $parameters
     * @return \\pestopancake\viapost-php\StructType\GetAvailableFundsResponse|bool
     */
    public function GetAvailableFunds(\\pestopancake\viapost-php\StructType\GetAvailableFunds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableFunds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a letter using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The LetterID text you supply will be identify your letter. This method returns
     * True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The returnLetter returns a CustomerAPILetter object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLetterByID $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLetterByIDResponse|bool
     */
    public function GetLetterByID(\\pestopancake\viapost-php\StructType\GetLetterByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetters
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a letter list. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The SearchDocumentName text you supply will be used to find your letter by its uploaded title. The
     * SearchDocumentName can be a partial string, in which case the first matching letter is returned. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The
     * returnLetters returns an arrayList of CustomerAPILetter objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLetters $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLettersResponse|bool
     */
    public function GetLetters(\\pestopancake\viapost-php\StructType\GetLetters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLibraryLetters
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of the user's letters that have been uploaded via the portal or the CreateLetter API method. Letters uploaded via the UploadDocument or UploadConsolidatedPDF API methods are not supported.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLibraryLetters $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLibraryLettersResponse|bool
     */
    public function GetLibraryLetters(\\pestopancake\viapost-php\StructType\GetLibraryLetters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLibraryLetters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingLists
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a list of mailing lists. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The SearchMailingListTitle text you supply will be used to find your mailing list by its
     * uploaded title. The SearchMailingListTitle can be a partial string, in which case the first matching mailing list is returned. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the
     * event of a failure. The returnMailinglists returns an ArrayList of CustomerAPIMailingList objects.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetMailingLists $parameters
     * @return \\pestopancake\viapost-php\StructType\GetMailingListsResponse|bool
     */
    public function GetMailingLists(\\pestopancake\viapost-php\StructType\GetMailingLists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailingLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingListByID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to retrieve a mailing list using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The MailingListID you supply will be used to locate your mailing list. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The returnMailinglist returns a CustomerAPIMailingList object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetMailingListByID $parameters
     * @return \\pestopancake\viapost-php\StructType\GetMailingListByIDResponse|bool
     */
    public function GetMailingListByID(\\pestopancake\viapost-php\StructType\GetMailingListByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMailingListByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMailingList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a mailing list using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The MailingListID you supply will be used to delete your mailing list. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteMailingList $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteMailingListResponse|bool
     */
    public function DeleteMailingList(\\pestopancake\viapost-php\StructType\DeleteMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMapping
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a mapping using its unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The mappingID you supply will be used to delete your mapping. This method returns
     * True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteMapping $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteMappingResponse|bool
     */
    public function DeleteMapping(\\pestopancake\viapost-php\StructType\DeleteMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteUserVariable
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a user variable using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The variableID you supply will be used to delete your user variable. This
     * method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteUserVariable $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteUserVariableResponse|bool
     */
    public function DeleteUserVariable(\\pestopancake\viapost-php\StructType\DeleteUserVariable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteUserVariable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letterhead using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The letterheadID you supply will be used to delete your letterhead. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteLetterhead $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteLetterheadResponse|bool
     */
    public function DeleteLetterhead(\\pestopancake\viapost-php\StructType\DeleteLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letter using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The letterID you supply will be used to delete the letter. This method returns True
     * if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteLetter $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteLetterResponse|bool
     */
    public function DeleteLetter(\\pestopancake\viapost-php\StructType\DeleteLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteAttachment
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete an attachment using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The attachmentID you supply will be used to delete your attachment. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteAttachment $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteAttachmentResponse|bool
     */
    public function DeleteAttachment(\\pestopancake\viapost-php\StructType\DeleteAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a postcard using it's unique ID. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The postcardID you supply will be used to delete your postcard. This method
     * returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeletePostcard $parameters
     * @return \\pestopancake\viapost-php\StructType\DeletePostcardResponse|bool
     */
    public function DeletePostcard(\\pestopancake\viapost-php\StructType\DeletePostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadMailingList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format (refer to the CustomerAPI documentation for details on the CSV format requirements). You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken).
     * The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a problem occured. The
     * ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\UploadMailingList $parameters
     * @return \\pestopancake\viapost-php\StructType\UploadMailingListResponse|bool
     */
    public function UploadMailingList(\\pestopancake\viapost-php\StructType\UploadMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadMailingListWithMapping
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format. You can also specify the ID of a custom mapping to successfully extract the addresses from your spreadsheet. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a
     * problem occured. The ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\UploadMailingListWithMapping $parameters
     * @return \\pestopancake\viapost-php\StructType\UploadMailingListWithMappingResponse|bool
     */
    public function UploadMailingListWithMapping(\\pestopancake\viapost-php\StructType\UploadMailingListWithMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingListWithMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UploadMailingListWithMappingAndShare
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format. You can also specify the ID of a custom mapping to successfully extract the addresses from your spreadsheet. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a
     * problem occured. The ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\UploadMailingListWithMappingAndShare $parameters
     * @return \\pestopancake\viapost-php\StructType\UploadMailingListWithMappingAndShareResponse|bool
     */
    public function UploadMailingListWithMappingAndShare(\\pestopancake\viapost-php\StructType\UploadMailingListWithMappingAndShare $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingListWithMappingAndShare($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadConsolidatedPDF
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method upload a Consolidated PDF. The consolidated PDF will be splint into individual documents based on SplitOptions and then sent/uploaded as individual letters.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\UploadConsolidatedPDF $parameters
     * @return \\pestopancake\viapost-php\StructType\UploadConsolidatedPDFResponse|bool
     */
    public function UploadConsolidatedPDF(\\pestopancake\viapost-php\StructType\UploadConsolidatedPDF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadConsolidatedPDF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MailMerge
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\MailMerge $parameters
     * @return \\pestopancake\viapost-php\StructType\MailMergeResponse|bool
     */
    public function MailMerge(\\pestopancake\viapost-php\StructType\MailMerge $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMerge($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * MailMergeWithExceptionsAndConfirmationEmails
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. You can choose whether you want to send a confirmation email out for each letter. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\MailMergeWithExceptionsAndConfirmationEmails $parameters
     * @return \\pestopancake\viapost-php\StructType\MailMergeWithExceptionsAndConfirmationEmailsResponse|bool
     */
    public function MailMergeWithExceptionsAndConfirmationEmails(\\pestopancake\viapost-php\StructType\MailMergeWithExceptionsAndConfirmationEmails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMergeWithExceptionsAndConfirmationEmails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MailMergeWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\MailMergeWithExceptions $parameters
     * @return \\pestopancake\viapost-php\StructType\MailMergeWithExceptionsResponse|bool
     */
    public function MailMergeWithExceptions(\\pestopancake\viapost-php\StructType\MailMergeWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMergeWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAccount
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a customer account. The method also adds a user to the customer account who is specified as the account admin. Refer to Documentation for information on which fields are required. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAccount $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAccountResponse|bool
     */
    public function CreateAccount(\\pestopancake\viapost-php\StructType\CreateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAccountNonUK
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a customer account. The method also adds a user to the customer account who is specified as the account admin. Refer to Documentation for information on which fields are required. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreateAccountNonUK $parameters
     * @return \\pestopancake\viapost-php\StructType\CreateAccountNonUKResponse|bool
     */
    public function CreateAccountNonUK(\\pestopancake\viapost-php\StructType\CreateAccountNonUK $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAccountNonUK($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccount
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\AddUserToAccount $parameters
     * @return \\pestopancake\viapost-php\StructType\AddUserToAccountResponse|bool
     */
    public function AddUserToAccount(\\pestopancake\viapost-php\StructType\AddUserToAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountPermissions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\AddUserToAccountPermissions $parameters
     * @return \\pestopancake\viapost-php\StructType\AddUserToAccountPermissionsResponse|bool
     */
    public function AddUserToAccountPermissions(\\pestopancake\viapost-php\StructType\AddUserToAccountPermissions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountPermissions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountNonUK
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\AddUserToAccountNonUK $parameters
     * @return \\pestopancake\viapost-php\StructType\AddUserToAccountNonUKResponse|bool
     */
    public function AddUserToAccountNonUK(\\pestopancake\viapost-php\StructType\AddUserToAccountNonUK $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountNonUK($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserToAccountNonUKPermissions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to add a user to a customer account. Your login token must belong an account admin to use this method. You can specify whether or not you want the created user to also be an admin. Refer to Documentation for
     * information on which fields are required. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. If you pass in an empty string for the password variable the method
     * will create a password for you and return it to this variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\AddUserToAccountNonUKPermissions $parameters
     * @return \\pestopancake\viapost-php\StructType\AddUserToAccountNonUKPermissionsResponse|bool
     */
    public function AddUserToAccountNonUKPermissions(\\pestopancake\viapost-php\StructType\AddUserToAccountNonUKPermissions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserToAccountNonUKPermissions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CalculateLetterCostComplexBatchWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a complex batch (one containing letters with different numbers of pages) that requires validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). You must also create a MailBatch Object which stores the details about the letters being sent in the batch. The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatchWithExceptions $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatchWithExceptionsResponse|bool
     */
    public function CalculateLetterCostComplexBatchWithExceptions(\\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatchWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostComplexBatchWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateLetterCostSimpleBatch
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a simple batch(one contaning letters with the same number of pages) that does not require validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatch $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatchResponse|bool
     */
    public function CalculateLetterCostSimpleBatch(\\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostSimpleBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CalculateLetterCostSimpleBatchWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a complex batch(one contaning letters with the same number of pages) that requires validation exceptions. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The method returns true on success and will also pass out the total Net Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatchWithExceptions $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatchWithExceptionsResponse|bool
     */
    public function CalculateLetterCostSimpleBatchWithExceptions(\\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatchWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostSimpleBatchWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateLetterCostComplexBatch
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to calculate a cost of a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The method returns true on success and will also pass out the total Net
     * Cost and VAT seperately.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatch $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatchResponse|bool
     */
    public function CalculateLetterCostComplexBatch(\\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateLetterCostComplexBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateMailMergeCost
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occurred. The
     * ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateMailMergeCost $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateMailMergeCostResponse|bool
     */
    public function CalculateMailMergeCost(\\pestopancake\viapost-php\StructType\CalculateMailMergeCost $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateMailMergeCost($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateEstimatedDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the estimated delivery date of a letter based on the time passed in. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn to acquire a
     * LoginToken). This method returns True if successful or False if a problem occured. The SendDateTime variable is the date and time when you wish to send letters out and the DeliveryDate is the estimated Royal Mail delivery date. The ReturnMessage
     * provides an explanation of the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDate $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDateResponse|bool
     */
    public function CalculateEstimatedDeliveryDate(\\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateEstimatedDeliveryDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateEstimatedDeliveryDateNow
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the estimated delivery date of a letter based on the current time. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn to acquire a
     * LoginToken). This method returns True if successful or False if a problem occured. The DeliveryDate is the estimated Royal Mail delivery date. The ReturnMessage provides an explanation of the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDateNow $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDateNowResponse|bool
     */
    public function CalculateEstimatedDeliveryDateNow(\\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDateNow $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateEstimatedDeliveryDateNow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateSendDateForDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to calculate the date on which you should send a letter for it to arrive on a specified date. This takes into account weekends, holidays and strikes. You must supply a valid LoginToken to use this method (use SignIn
     * to acquire a LoginToken). This method returns True if successful or False if a problem occured. The earliest and latest SendDate are the estimated send dates based on our batching and Royal Mail delivery. The ReturnMessage provides an explanation of
     * the estimated delivery date.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CalculateSendDateForDeliveryDate $parameters
     * @return \\pestopancake\viapost-php\StructType\CalculateSendDateForDeliveryDateResponse|bool
     */
    public function CalculateSendDateForDeliveryDate(\\pestopancake\viapost-php\StructType\CalculateSendDateForDeliveryDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateSendDateForDeliveryDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterStatusByLetterID
     * Meta information extracted from the WSDL
     * - documentation: Use this method to check the status of a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by an ID must belong to you. This method returns True if successful
     * or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLetterStatusByLetterID $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLetterStatusByLetterIDResponse|bool
     */
    public function GetLetterStatusByLetterID(\\pestopancake\viapost-php\StructType\GetLetterStatusByLetterID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterStatusByLetterID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLetterStatusByCustomerAPILetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to check the status of a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by a CustomerAPILetter object must belong to you. This method
     * returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetLetterStatusByCustomerAPILetter $parameters
     * @return \\pestopancake\viapost-php\StructType\GetLetterStatusByCustomerAPILetterResponse|bool
     */
    public function GetLetterStatusByCustomerAPILetter(\\pestopancake\viapost-php\StructType\GetLetterStatusByCustomerAPILetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLetterStatusByCustomerAPILetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterByLetterID
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to delete a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by an ID must belong to you. This method returns True if successful
     * or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteLetterByLetterID $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteLetterByLetterIDResponse|bool
     */
    public function DeleteLetterByLetterID(\\pestopancake\viapost-php\StructType\DeleteLetterByLetterID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterByLetterID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteLetterByCustomerAPILetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken) and the letter specified by a CustomerAPILetter object must belong to you. This method returns True if
     * successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeleteLetterByCustomerAPILetter $parameters
     * @return \\pestopancake\viapost-php\StructType\DeleteLetterByCustomerAPILetterResponse|bool
     */
    public function DeleteLetterByCustomerAPILetter(\\pestopancake\viapost-php\StructType\DeleteLetterByCustomerAPILetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteLetterByCustomerAPILetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create a new price band. You must supply a valid GUID to use this method as well as a unique description string to identify the price band. This method returns True if successful or False if a problem occured. It
     * also provides the PriceBandID for your use. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\CreatePriceBand $parameters
     * @return \\pestopancake\viapost-php\StructType\CreatePriceBandResponse|bool
     */
    public function CreatePriceBand(\\pestopancake\viapost-php\StructType\CreatePriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AssignPriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to assign a price band to a customer. You must supply a valid GUID to use this method as well as a username associated with the customer account and the ID of the price band that you wish to apply. The customer and
     * price band must be associated with your GUID. This method returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\AssignPriceBand $parameters
     * @return \\pestopancake\viapost-php\StructType\AssignPriceBandResponse|bool
     */
    public function AssignPriceBand(\\pestopancake\viapost-php\StructType\AssignPriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AssignPriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPriceBands
     * Meta information extracted from the WSDL
     * - documentation: Use this method to return a delimited string containing the details of all price bands associated with your GUID. You must supply a valid GUID to use this method. This method returns True if successful or False if a problem occured.
     * The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetPriceBands $parameters
     * @return \\pestopancake\viapost-php\StructType\GetPriceBandsResponse|bool
     */
    public function GetPriceBands(\\pestopancake\viapost-php\StructType\GetPriceBands $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPriceBands($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePriceBand
     * Meta information extracted from the WSDL
     * - documentation: Use this method to delete a price band. You must supply a valid GUID to use this method as well as the ID of the price band which you wish to delete. You can only delete a price band if no customers are currently using it. This
     * method returns True if successful or False if a problem occured. The ReturnMessage provides details about the status or any problems that occurred.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DeletePriceBand $parameters
     * @return \\pestopancake\viapost-php\StructType\DeletePriceBandResponse|bool
     */
    public function DeletePriceBand(\\pestopancake\viapost-php\StructType\DeletePriceBand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeletePriceBand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountries
     * Meta information extracted from the WSDL
     * - documentation: Use this method to get a list of all of the countries and their associated IDs. You need an ID to pass into the CreateAccount or AddUserToAccount methods if you wish to specify a non-UK address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetCountries $parameters
     * @return \\pestopancake\viapost-php\StructType\GetCountriesResponse|bool
     */
    public function GetCountries(\\pestopancake\viapost-php\StructType\GetCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DisableUser
     * Meta information extracted from the WSDL
     * - documentation: Use this method to disable a user account. You need to specify the username of the account that you wish to disable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\DisableUser $parameters
     * @return \\pestopancake\viapost-php\StructType\DisableUserResponse|bool
     */
    public function DisableUser(\\pestopancake\viapost-php\StructType\DisableUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DisableUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessage
     * Meta information extracted from the WSDL
     * - documentation: Get the return message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GetMessage $parameters
     * @return \\pestopancake\viapost-php\StructType\GetMessageResponse|bool
     */
    public function GetMessage(\\pestopancake\viapost-php\StructType\GetMessage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMapping
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GenerateMapping $parameters
     * @return \\pestopancake\viapost-php\StructType\GenerateMappingResponse|bool
     */
    public function GenerateMapping(\\pestopancake\viapost-php\StructType\GenerateMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateMappingWithDefaultName
     * Meta information extracted from the WSDL
     * - documentation: Generate an XML Mapping for a Mailing List and specify a default name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultName $parameters
     * @return \\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameResponse|bool
     */
    public function GenerateMappingWithDefaultName(\\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateMappingWithDefaultName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\pestopancake\viapost-php\StructType\AddExcludedAddressResponse|\\pestopancake\viapost-php\StructType\AddUserToAccountNonUKPermissionsResponse|\\pestopancake\viapost-php\StructType\AddUserToAccountNonUKResponse|\\pestopancake\viapost-php\StructType\AddUserToAccountPermissionsResponse|\\pestopancake\viapost-php\StructType\AddUserToAccountResponse|\\pestopancake\viapost-php\StructType\AssignPriceBandResponse|\\pestopancake\viapost-php\StructType\CalculateCostOfDataListResponse|\\pestopancake\viapost-php\StructType\CalculateCostOfFindNearestMailingResponse|\\pestopancake\viapost-php\StructType\CalculateCostOfMailingResponse|\\pestopancake\viapost-php\StructType\CalculateCostOfNewMailingResponse|\\pestopancake\viapost-php\StructType\CalculateCostOfSingleAddressMailingResponse|\\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDateNowResponse|\\pestopancake\viapost-php\StructType\CalculateEstimatedDeliveryDateResponse|\\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatchResponse|\\pestopancake\viapost-php\StructType\CalculateLetterCostComplexBatchWithExceptionsResponse|\\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatchResponse|\\pestopancake\viapost-php\StructType\CalculateLetterCostSimpleBatchWithExceptionsResponse|\\pestopancake\viapost-php\StructType\CalculateMailMergeCostResponse|\\pestopancake\viapost-php\StructType\CalculateSendDateForDeliveryDateResponse|\\pestopancake\viapost-php\StructType\ChangePasswordResponse|\\pestopancake\viapost-php\StructType\CreateAccountNonUKResponse|\\pestopancake\viapost-php\StructType\CreateAccountResponse|\\pestopancake\viapost-php\StructType\CreateAndSendMailPackResponse|\\pestopancake\viapost-php\StructType\CreateAndSendMailPackToFindNearestResponse|\\pestopancake\viapost-php\StructType\CreateAndSendMailPackToSingleAddressResponse|\\pestopancake\viapost-php\StructType\CreateAndSendPostcardResponse|\\pestopancake\viapost-php\StructType\CreateAndSendPostcardToFindNearestResponse|\\pestopancake\viapost-php\StructType\CreateAndSendPostcardToSingleAddressResponse|\\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingResponse|\\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToFindNearestResponse|\\pestopancake\viapost-php\StructType\CreateAndSendSimpleMailingToSingleAddressResponse|\\pestopancake\viapost-php\StructType\CreateAttachmentResponse|\\pestopancake\viapost-php\StructType\CreateJobRunRecordResponse|\\pestopancake\viapost-php\StructType\CreateLetterFromXPSResponse|\\pestopancake\viapost-php\StructType\CreateLetterheadResponse|\\pestopancake\viapost-php\StructType\CreateLetterResponse|\\pestopancake\viapost-php\StructType\CreateMailPackResponse|\\pestopancake\viapost-php\StructType\CreatePostcardResponse|\\pestopancake\viapost-php\StructType\CreatePriceBandResponse|\\pestopancake\viapost-php\StructType\DeleteAttachmentResponse|\\pestopancake\viapost-php\StructType\DeleteExcludedAddressByIDResponse|\\pestopancake\viapost-php\StructType\DeleteLetterByCustomerAPILetterResponse|\\pestopancake\viapost-php\StructType\DeleteLetterByLetterIDResponse|\\pestopancake\viapost-php\StructType\DeleteLetterheadResponse|\\pestopancake\viapost-php\StructType\DeleteLetterResponse|\\pestopancake\viapost-php\StructType\DeleteMailingListResponse|\\pestopancake\viapost-php\StructType\DeleteMailPackResponse|\\pestopancake\viapost-php\StructType\DeleteMappingResponse|\\pestopancake\viapost-php\StructType\DeletePostcardResponse|\\pestopancake\viapost-php\StructType\DeletePriceBandResponse|\\pestopancake\viapost-php\StructType\DeleteUserVariableResponse|\\pestopancake\viapost-php\StructType\DisableUserResponse|\\pestopancake\viapost-php\StructType\DownloadDataListResponse|\\pestopancake\viapost-php\StructType\FindNearestExecuteSearchResponse|\\pestopancake\viapost-php\StructType\FindNearestQueryAddressResponse|\\pestopancake\viapost-php\StructType\GenerateMappingResponse|\\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFieldsResponse|\\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithIDResponse|\\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameResponse|\\pestopancake\viapost-php\StructType\GenerateMappingWithDefaultNameWithIDResponse|\\pestopancake\viapost-php\StructType\GenerateMappingWithIDResponse|\\pestopancake\viapost-php\StructType\GetAccountUrlResponse|\\pestopancake\viapost-php\StructType\GetAddressesForPostcodeResponse|\\pestopancake\viapost-php\StructType\GetAvailableFundsResponse|\\pestopancake\viapost-php\StructType\GetBalanceResponse|\\pestopancake\viapost-php\StructType\GetCostCentresResponse|\\pestopancake\viapost-php\StructType\GetCountriesResponse|\\pestopancake\viapost-php\StructType\GetDataListsResponse|\\pestopancake\viapost-php\StructType\GetDataListUrlResponse|\\pestopancake\viapost-php\StructType\GetDocumentationResponse|\\pestopancake\viapost-php\StructType\GetDocumentPageCountRangeResponse|\\pestopancake\viapost-php\StructType\GetDocumentReservedAreasResponse|\\pestopancake\viapost-php\StructType\GetDocumentStickerAreaResponse|\\pestopancake\viapost-php\StructType\GetExcludedAddressesResponse|\\pestopancake\viapost-php\StructType\GetLatestVersionDetailsResponse|\\pestopancake\viapost-php\StructType\GetLetterByIDResponse|\\pestopancake\viapost-php\StructType\GetLettersResponse|\\pestopancake\viapost-php\StructType\GetLetterStatusByCustomerAPILetterResponse|\\pestopancake\viapost-php\StructType\GetLetterStatusByLetterIDResponse|\\pestopancake\viapost-php\StructType\GetLibraryAttachmentsResponse|\\pestopancake\viapost-php\StructType\GetLibraryInsertsResponse|\\pestopancake\viapost-php\StructType\GetLibraryLetterheadsResponse|\\pestopancake\viapost-php\StructType\GetLibraryLettersResponse|\\pestopancake\viapost-php\StructType\GetLibraryMailPacksResponse|\\pestopancake\viapost-php\StructType\GetLibraryMappingsResponse|\\pestopancake\viapost-php\StructType\GetLibraryPostcardsResponse|\\pestopancake\viapost-php\StructType\GetMailHistoryDocumentsByJobIdResponse|\\pestopancake\viapost-php\StructType\GetMailHistoryJobsResponse|\\pestopancake\viapost-php\StructType\GetMailingListByIDResponse|\\pestopancake\viapost-php\StructType\GetMailingListsResponse|\\pestopancake\viapost-php\StructType\GetMailPacksResponse|\\pestopancake\viapost-php\StructType\GetMessageResponse|\\pestopancake\viapost-php\StructType\GetPortalUrlResponse|\\pestopancake\viapost-php\StructType\GetPriceBandsResponse|\\pestopancake\viapost-php\StructType\GetSystemIDResponse|\\pestopancake\viapost-php\StructType\GetUserDetailsResponse|\\pestopancake\viapost-php\StructType\GetUserVariablesResponse|\\pestopancake\viapost-php\StructType\IsFirstClassAvailableResponse|\\pestopancake\viapost-php\StructType\IsValidLoginTokenResponse|\\pestopancake\viapost-php\StructType\MailMergeResponse|\\pestopancake\viapost-php\StructType\MailMergeWithExceptionsAndConfirmationEmailsResponse|\\pestopancake\viapost-php\StructType\MailMergeWithExceptionsResponse|\\pestopancake\viapost-php\StructType\PreviewDocumentFindNearestResponse|\\pestopancake\viapost-php\StructType\PreviewDocumentMailingListResponse|\\pestopancake\viapost-php\StructType\PreviewDocumentSingleAddressResponse|\\pestopancake\viapost-php\StructType\PreviewLetterResponse|\\pestopancake\viapost-php\StructType\PreviewLibraryAttachmentResponse|\\pestopancake\viapost-php\StructType\PreviewLibraryLetterheadResponse|\\pestopancake\viapost-php\StructType\PreviewLibraryLetterResponse|\\pestopancake\viapost-php\StructType\PreviewLibraryPostcardResponse|\\pestopancake\viapost-php\StructType\PreviewMailPackResponse|\\pestopancake\viapost-php\StructType\RetryLetterResponse|\\pestopancake\viapost-php\StructType\SearchAddressResponse|\\pestopancake\viapost-php\StructType\SendDriverMailingConfirmationResponse|\\pestopancake\viapost-php\StructType\SendLetterResponse|\\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddressAndExceptionsResponse|\\pestopancake\viapost-php\StructType\SendLetterWithStructuredAddressResponse|\\pestopancake\viapost-php\StructType\SendMailPackResponse|\\pestopancake\viapost-php\StructType\SendMailPackToFindNearestResponse|\\pestopancake\viapost-php\StructType\SendMailPackToSingleAddress2Response|\\pestopancake\viapost-php\StructType\SendMailPackToSingleAddressResponse|\\pestopancake\viapost-php\StructType\SendPostcardResponse|\\pestopancake\viapost-php\StructType\SendPostcardToFindNearestResponse|\\pestopancake\viapost-php\StructType\SendPostcardToSingleAddressResponse|\\pestopancake\viapost-php\StructType\SendSimpleMailingResponse|\\pestopancake\viapost-php\StructType\SendSimpleMailingToFindNearestResponse|\\pestopancake\viapost-php\StructType\SendSimpleMailingToSingleAddressResponse|\\pestopancake\viapost-php\StructType\SignInResponse|\\pestopancake\viapost-php\StructType\UpdateLetterResponse|\\pestopancake\viapost-php\StructType\UpdateMailPackLetterResponse|\\pestopancake\viapost-php\StructType\UpdateMailPackTemplateResponse|\\pestopancake\viapost-php\StructType\UploadConsolidatedPDFResponse|\\pestopancake\viapost-php\StructType\UploadDocumentResponse|\\pestopancake\viapost-php\StructType\UploadMailingListResponse|\\pestopancake\viapost-php\StructType\UploadMailingListWithMappingAndShareResponse|\\pestopancake\viapost-php\StructType\UploadMailingListWithMappingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
