<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.viapost.com/viapostcustomer.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.viapost.com/viapostcustomer.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetSystemID operation/method
 */
if ($get->GetSystemID(new \StructType\GetSystemID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDocumentPageCountRange operation/method
 */
if ($get->GetDocumentPageCountRange(new \StructType\GetDocumentPageCountRange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLibraryInserts operation/method
 */
if ($get->GetLibraryInserts(new \StructType\GetLibraryInserts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCostCentres operation/method
 */
if ($get->GetCostCentres(new \StructType\GetCostCentres()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExcludedAddresses operation/method
 */
if ($get->GetExcludedAddresses(new \StructType\GetExcludedAddresses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailPacks operation/method
 */
if ($get->GetMailPacks(new \StructType\GetMailPacks()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLibraryMailPacks operation/method
 */
if ($get->GetLibraryMailPacks(new \StructType\GetLibraryMailPacks()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLibraryPostcards operation/method
 */
if ($get->GetLibraryPostcards(new \StructType\GetLibraryPostcards()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLibraryLetterheads operation/method
 */
if ($get->GetLibraryLetterheads(new \StructType\GetLibraryLetterheads()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLibraryAttachments operation/method
 */
if ($get->GetLibraryAttachments(new \StructType\GetLibraryAttachments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLibraryMappings operation/method
 */
if ($get->GetLibraryMappings(new \StructType\GetLibraryMappings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDataListUrl operation/method
 */
if ($get->GetDataListUrl(new \StructType\GetDataListUrl()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDataLists operation/method
 */
if ($get->GetDataLists(new \StructType\GetDataLists()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserVariables operation/method
 */
if ($get->GetUserVariables(new \StructType\GetUserVariables()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDocumentation operation/method
 */
if ($get->GetDocumentation(new \StructType\GetDocumentation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailHistoryJobs operation/method
 */
if ($get->GetMailHistoryJobs(new \StructType\GetMailHistoryJobs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailHistoryDocumentsByJobId operation/method
 */
if ($get->GetMailHistoryDocumentsByJobId(new \StructType\GetMailHistoryDocumentsByJobId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAddressesForPostcode operation/method
 */
if ($get->GetAddressesForPostcode(new \StructType\GetAddressesForPostcode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDocumentStickerArea operation/method
 */
if ($get->GetDocumentStickerArea(new \StructType\GetDocumentStickerArea()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDocumentReservedAreas operation/method
 */
if ($get->GetDocumentReservedAreas(new \StructType\GetDocumentReservedAreas()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserDetails operation/method
 */
if ($get->GetUserDetails(new \StructType\GetUserDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLatestVersionDetails operation/method
 */
if ($get->GetLatestVersionDetails(new \StructType\GetLatestVersionDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountUrl operation/method
 */
if ($get->GetAccountUrl(new \StructType\GetAccountUrl()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPortalUrl operation/method
 */
if ($get->GetPortalUrl(new \StructType\GetPortalUrl()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBalance operation/method
 */
if ($get->GetBalance(new \StructType\GetBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableFunds operation/method
 */
if ($get->GetAvailableFunds(new \StructType\GetAvailableFunds()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLetterByID operation/method
 */
if ($get->GetLetterByID(new \StructType\GetLetterByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLetters operation/method
 */
if ($get->GetLetters(new \StructType\GetLetters()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLibraryLetters operation/method
 */
if ($get->GetLibraryLetters(new \StructType\GetLibraryLetters()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailingLists operation/method
 */
if ($get->GetMailingLists(new \StructType\GetMailingLists()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailingListByID operation/method
 */
if ($get->GetMailingListByID(new \StructType\GetMailingListByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLetterStatusByLetterID operation/method
 */
if ($get->GetLetterStatusByLetterID(new \StructType\GetLetterStatusByLetterID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLetterStatusByCustomerAPILetter operation/method
 */
if ($get->GetLetterStatusByCustomerAPILetter(new \StructType\GetLetterStatusByCustomerAPILetter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPriceBands operation/method
 */
if ($get->GetPriceBands(new \StructType\GetPriceBands()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCountries operation/method
 */
if ($get->GetCountries(new \StructType\GetCountries()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMessage operation/method
 */
if ($get->GetMessage(new \StructType\GetMessage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateLetterFromXPS operation/method
 */
if ($create->CreateLetterFromXPS(new \StructType\CreateLetterFromXPS()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAttachment operation/method
 */
if ($create->CreateAttachment(new \StructType\CreateAttachment()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateLetterhead operation/method
 */
if ($create->CreateLetterhead(new \StructType\CreateLetterhead()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateLetter operation/method
 */
if ($create->CreateLetter(new \StructType\CreateLetter()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMailPack operation/method
 */
if ($create->CreateMailPack(new \StructType\CreateMailPack()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendMailPack operation/method
 */
if ($create->CreateAndSendMailPack(new \StructType\CreateAndSendMailPack()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendMailPackToSingleAddress operation/method
 */
if ($create->CreateAndSendMailPackToSingleAddress(new \StructType\CreateAndSendMailPackToSingleAddress()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailingToFindNearest operation/method
 */
if ($create->CreateAndSendSimpleMailingToFindNearest(new \StructType\CreateAndSendSimpleMailingToFindNearest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailing operation/method
 */
if ($create->CreateAndSendSimpleMailing(new \StructType\CreateAndSendSimpleMailing()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailingToSingleAddress operation/method
 */
if ($create->CreateAndSendSimpleMailingToSingleAddress(new \StructType\CreateAndSendSimpleMailingToSingleAddress()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendMailPackToFindNearest operation/method
 */
if ($create->CreateAndSendMailPackToFindNearest(new \StructType\CreateAndSendMailPackToFindNearest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePostcard operation/method
 */
if ($create->CreatePostcard(new \StructType\CreatePostcard()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendPostcardToSingleAddress operation/method
 */
if ($create->CreateAndSendPostcardToSingleAddress(new \StructType\CreateAndSendPostcardToSingleAddress()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendPostcard operation/method
 */
if ($create->CreateAndSendPostcard(new \StructType\CreateAndSendPostcard()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAndSendPostcardToFindNearest operation/method
 */
if ($create->CreateAndSendPostcardToFindNearest(new \StructType\CreateAndSendPostcardToFindNearest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateJobRunRecord operation/method
 */
if ($create->CreateJobRunRecord(new \StructType\CreateJobRunRecord()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAccount operation/method
 */
if ($create->CreateAccount(new \StructType\CreateAccount()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAccountNonUK operation/method
 */
if ($create->CreateAccountNonUK(new \StructType\CreateAccountNonUK()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePriceBand operation/method
 */
if ($create->CreatePriceBand(new \StructType\CreatePriceBand()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for SendDriverMailingConfirmation operation/method
 */
if ($send->SendDriverMailingConfirmation(new \StructType\SendDriverMailingConfirmation()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMailPack operation/method
 */
if ($send->SendMailPack(new \StructType\SendMailPack()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMailPackToFindNearest operation/method
 */
if ($send->SendMailPackToFindNearest(new \StructType\SendMailPackToFindNearest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMailPackToSingleAddress2 operation/method
 */
if ($send->SendMailPackToSingleAddress2(new \StructType\SendMailPackToSingleAddress2()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMailPackToSingleAddress operation/method
 */
if ($send->SendMailPackToSingleAddress(new \StructType\SendMailPackToSingleAddress()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSimpleMailing operation/method
 */
if ($send->SendSimpleMailing(new \StructType\SendSimpleMailing()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSimpleMailingToFindNearest operation/method
 */
if ($send->SendSimpleMailingToFindNearest(new \StructType\SendSimpleMailingToFindNearest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSimpleMailingToSingleAddress operation/method
 */
if ($send->SendSimpleMailingToSingleAddress(new \StructType\SendSimpleMailingToSingleAddress()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendPostcardToSingleAddress operation/method
 */
if ($send->SendPostcardToSingleAddress(new \StructType\SendPostcardToSingleAddress()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendPostcard operation/method
 */
if ($send->SendPostcard(new \StructType\SendPostcard()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendPostcardToFindNearest operation/method
 */
if ($send->SendPostcardToFindNearest(new \StructType\SendPostcardToFindNearest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendLetterWithStructuredAddress operation/method
 */
if ($send->SendLetterWithStructuredAddress(new \StructType\SendLetterWithStructuredAddress()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendLetterWithStructuredAddressAndExceptions operation/method
 */
if ($send->SendLetterWithStructuredAddressAndExceptions(new \StructType\SendLetterWithStructuredAddressAndExceptions()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendLetter operation/method
 */
if ($send->SendLetter(new \StructType\SendLetter()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
/**
 * Sample call for GenerateMappingWithDefaultNameAndMergeFields operation/method
 */
if ($generate->GenerateMappingWithDefaultNameAndMergeFields(new \StructType\GenerateMappingWithDefaultNameAndMergeFields()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateMappingWithID operation/method
 */
if ($generate->GenerateMappingWithID(new \StructType\GenerateMappingWithID()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameWithID operation/method
 */
if ($generate->GenerateMappingWithDefaultNameWithID(new \StructType\GenerateMappingWithDefaultNameWithID()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameAndMergeFieldsWithID
 * operation/method
 */
if ($generate->GenerateMappingWithDefaultNameAndMergeFieldsWithID(new \StructType\GenerateMappingWithDefaultNameAndMergeFieldsWithID()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateMapping operation/method
 */
if ($generate->GenerateMapping(new \StructType\GenerateMapping()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultName operation/method
 */
if ($generate->GenerateMappingWithDefaultName(new \StructType\GenerateMappingWithDefaultName()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteMailPack operation/method
 */
if ($delete->DeleteMailPack(new \StructType\DeleteMailPack()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteExcludedAddressByID operation/method
 */
if ($delete->DeleteExcludedAddressByID(new \StructType\DeleteExcludedAddressByID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMailingList operation/method
 */
if ($delete->DeleteMailingList(new \StructType\DeleteMailingList()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMapping operation/method
 */
if ($delete->DeleteMapping(new \StructType\DeleteMapping()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteUserVariable operation/method
 */
if ($delete->DeleteUserVariable(new \StructType\DeleteUserVariable()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteLetterhead operation/method
 */
if ($delete->DeleteLetterhead(new \StructType\DeleteLetterhead()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteLetter operation/method
 */
if ($delete->DeleteLetter(new \StructType\DeleteLetter()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAttachment operation/method
 */
if ($delete->DeleteAttachment(new \StructType\DeleteAttachment()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeletePostcard operation/method
 */
if ($delete->DeletePostcard(new \StructType\DeletePostcard()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteLetterByLetterID operation/method
 */
if ($delete->DeleteLetterByLetterID(new \StructType\DeleteLetterByLetterID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteLetterByCustomerAPILetter operation/method
 */
if ($delete->DeleteLetterByCustomerAPILetter(new \StructType\DeleteLetterByCustomerAPILetter()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeletePriceBand operation/method
 */
if ($delete->DeletePriceBand(new \StructType\DeletePriceBand()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddExcludedAddress operation/method
 */
if ($add->AddExcludedAddress(new \StructType\AddExcludedAddress()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUserToAccount operation/method
 */
if ($add->AddUserToAccount(new \StructType\AddUserToAccount()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUserToAccountPermissions operation/method
 */
if ($add->AddUserToAccountPermissions(new \StructType\AddUserToAccountPermissions()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUserToAccountNonUK operation/method
 */
if ($add->AddUserToAccountNonUK(new \StructType\AddUserToAccountNonUK()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUserToAccountNonUKPermissions operation/method
 */
if ($add->AddUserToAccountNonUKPermissions(new \StructType\AddUserToAccountNonUKPermissions()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for FindNearestQueryAddress operation/method
 */
if ($find->FindNearestQueryAddress(new \StructType\FindNearestQueryAddress()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for FindNearestExecuteSearch operation/method
 */
if ($find->FindNearestExecuteSearch(new \StructType\FindNearestExecuteSearch()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateLetter operation/method
 */
if ($update->UpdateLetter(new \StructType\UpdateLetter()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateMailPackLetter operation/method
 */
if ($update->UpdateMailPackLetter(new \StructType\UpdateMailPackLetter()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateMailPackTemplate operation/method
 */
if ($update->UpdateMailPackTemplate(new \StructType\UpdateMailPackTemplate()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Preview ServiceType
 */
$preview = new \ServiceType\Preview($options);
/**
 * Sample call for PreviewLibraryPostcard operation/method
 */
if ($preview->PreviewLibraryPostcard(new \StructType\PreviewLibraryPostcard()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewLibraryLetterhead operation/method
 */
if ($preview->PreviewLibraryLetterhead(new \StructType\PreviewLibraryLetterhead()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewLibraryAttachment operation/method
 */
if ($preview->PreviewLibraryAttachment(new \StructType\PreviewLibraryAttachment()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewDocumentSingleAddress operation/method
 */
if ($preview->PreviewDocumentSingleAddress(new \StructType\PreviewDocumentSingleAddress()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewDocumentMailingList operation/method
 */
if ($preview->PreviewDocumentMailingList(new \StructType\PreviewDocumentMailingList()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewDocumentFindNearest operation/method
 */
if ($preview->PreviewDocumentFindNearest(new \StructType\PreviewDocumentFindNearest()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewLetter operation/method
 */
if ($preview->PreviewLetter(new \StructType\PreviewLetter()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewLibraryLetter operation/method
 */
if ($preview->PreviewLibraryLetter(new \StructType\PreviewLibraryLetter()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Sample call for PreviewMailPack operation/method
 */
if ($preview->PreviewMailPack(new \StructType\PreviewMailPack()) !== false) {
    print_r($preview->getResult());
} else {
    print_r($preview->getLastError());
}
/**
 * Samples for Calculate ServiceType
 */
$calculate = new \ServiceType\Calculate($options);
/**
 * Sample call for CalculateCostOfSingleAddressMailing operation/method
 */
if ($calculate->CalculateCostOfSingleAddressMailing(new \StructType\CalculateCostOfSingleAddressMailing()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateCostOfMailing operation/method
 */
if ($calculate->CalculateCostOfMailing(new \StructType\CalculateCostOfMailing()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateCostOfFindNearestMailing operation/method
 */
if ($calculate->CalculateCostOfFindNearestMailing(new \StructType\CalculateCostOfFindNearestMailing()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateCostOfDataList operation/method
 */
if ($calculate->CalculateCostOfDataList(new \StructType\CalculateCostOfDataList()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateCostOfNewMailing operation/method
 */
if ($calculate->CalculateCostOfNewMailing(new \StructType\CalculateCostOfNewMailing()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateLetterCostComplexBatchWithExceptions operation/method
 */
if ($calculate->CalculateLetterCostComplexBatchWithExceptions(new \StructType\CalculateLetterCostComplexBatchWithExceptions()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateLetterCostSimpleBatch operation/method
 */
if ($calculate->CalculateLetterCostSimpleBatch(new \StructType\CalculateLetterCostSimpleBatch()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateLetterCostSimpleBatchWithExceptions operation/method
 */
if ($calculate->CalculateLetterCostSimpleBatchWithExceptions(new \StructType\CalculateLetterCostSimpleBatchWithExceptions()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateLetterCostComplexBatch operation/method
 */
if ($calculate->CalculateLetterCostComplexBatch(new \StructType\CalculateLetterCostComplexBatch()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateMailMergeCost operation/method
 */
if ($calculate->CalculateMailMergeCost(new \StructType\CalculateMailMergeCost()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateEstimatedDeliveryDate operation/method
 */
if ($calculate->CalculateEstimatedDeliveryDate(new \StructType\CalculateEstimatedDeliveryDate()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateEstimatedDeliveryDateNow operation/method
 */
if ($calculate->CalculateEstimatedDeliveryDateNow(new \StructType\CalculateEstimatedDeliveryDateNow()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for CalculateSendDateForDeliveryDate operation/method
 */
if ($calculate->CalculateSendDateForDeliveryDate(new \StructType\CalculateSendDateForDeliveryDate()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Samples for Download ServiceType
 */
$download = new \ServiceType\Download($options);
/**
 * Sample call for DownloadDataList operation/method
 */
if ($download->DownloadDataList(new \StructType\DownloadDataList()) !== false) {
    print_r($download->getResult());
} else {
    print_r($download->getLastError());
}
/**
 * Samples for Retry ServiceType
 */
$retry = new \ServiceType\Retry($options);
/**
 * Sample call for RetryLetter operation/method
 */
if ($retry->RetryLetter(new \StructType\RetryLetter()) !== false) {
    print_r($retry->getResult());
} else {
    print_r($retry->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for IsFirstClassAvailable operation/method
 */
if ($is->IsFirstClassAvailable(new \StructType\IsFirstClassAvailable()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for IsValidLoginToken operation/method
 */
if ($is->IsValidLoginToken(new \StructType\IsValidLoginToken()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for ChangePassword operation/method
 */
if ($change->ChangePassword(new \StructType\ChangePassword()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Sign ServiceType
 */
$sign = new \ServiceType\Sign($options);
/**
 * Sample call for SignIn operation/method
 */
if ($sign->SignIn(new \StructType\SignIn()) !== false) {
    print_r($sign->getResult());
} else {
    print_r($sign->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
/**
 * Sample call for UploadDocument operation/method
 */
if ($upload->UploadDocument(new \StructType\UploadDocument()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadMailingList operation/method
 */
if ($upload->UploadMailingList(new \StructType\UploadMailingList()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadMailingListWithMapping operation/method
 */
if ($upload->UploadMailingListWithMapping(new \StructType\UploadMailingListWithMapping()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadMailingListWithMappingAndShare operation/method
 */
if ($upload->UploadMailingListWithMappingAndShare(new \StructType\UploadMailingListWithMappingAndShare()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Sample call for UploadConsolidatedPDF operation/method
 */
if ($upload->UploadConsolidatedPDF(new \StructType\UploadConsolidatedPDF()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for SearchAddress operation/method
 */
if ($search->SearchAddress(new \StructType\SearchAddress()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Mail ServiceType
 */
$mail = new \ServiceType\Mail($options);
/**
 * Sample call for MailMerge operation/method
 */
if ($mail->MailMerge(new \StructType\MailMerge()) !== false) {
    print_r($mail->getResult());
} else {
    print_r($mail->getLastError());
}
/**
 * Sample call for MailMergeWithExceptionsAndConfirmationEmails operation/method
 */
if ($mail->MailMergeWithExceptionsAndConfirmationEmails(new \StructType\MailMergeWithExceptionsAndConfirmationEmails()) !== false) {
    print_r($mail->getResult());
} else {
    print_r($mail->getLastError());
}
/**
 * Sample call for MailMergeWithExceptions operation/method
 */
if ($mail->MailMergeWithExceptions(new \StructType\MailMergeWithExceptions()) !== false) {
    print_r($mail->getResult());
} else {
    print_r($mail->getLastError());
}
/**
 * Samples for Assign ServiceType
 */
$assign = new \ServiceType\Assign($options);
/**
 * Sample call for AssignPriceBand operation/method
 */
if ($assign->AssignPriceBand(new \StructType\AssignPriceBand()) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Samples for Disable ServiceType
 */
$disable = new \ServiceType\Disable($options);
/**
 * Sample call for DisableUser operation/method
 */
if ($disable->DisableUser(new \StructType\DisableUser()) !== false) {
    print_r($disable->getResult());
} else {
    print_r($disable->getLastError());
}
