<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadMailingListResponse StructType
 * @subpackage Structs
 */
class UploadMailingListResponse extends AbstractStructBase
{
    /**
     * The UploadMailingListResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UploadMailingListResult;
    /**
     * The MailingListID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MailingListID;
    /**
     * The NumberOfUploadedAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfUploadedAddresses;
    /**
     * The NumberOfValidAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfValidAddresses;
    /**
     * The NumberOfApprovedAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfApprovedAddresses;
    /**
     * The NumberOfForceThroughAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfForceThroughAddresses;
    /**
     * The NumberOfFailedAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfFailedAddresses;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for UploadMailingListResponse
     * @uses UploadMailingListResponse::setUploadMailingListResult()
     * @uses UploadMailingListResponse::setMailingListID()
     * @uses UploadMailingListResponse::setNumberOfUploadedAddresses()
     * @uses UploadMailingListResponse::setNumberOfValidAddresses()
     * @uses UploadMailingListResponse::setNumberOfApprovedAddresses()
     * @uses UploadMailingListResponse::setNumberOfForceThroughAddresses()
     * @uses UploadMailingListResponse::setNumberOfFailedAddresses()
     * @uses UploadMailingListResponse::setSReturnMessage()
     * @param bool $uploadMailingListResult
     * @param int $mailingListID
     * @param int $numberOfUploadedAddresses
     * @param int $numberOfValidAddresses
     * @param int $numberOfApprovedAddresses
     * @param int $numberOfForceThroughAddresses
     * @param int $numberOfFailedAddresses
     * @param string $sReturnMessage
     */
    public function __construct($uploadMailingListResult = null, $mailingListID = null, $numberOfUploadedAddresses = null, $numberOfValidAddresses = null, $numberOfApprovedAddresses = null, $numberOfForceThroughAddresses = null, $numberOfFailedAddresses = null, $sReturnMessage = null)
    {
        $this
            ->setUploadMailingListResult($uploadMailingListResult)
            ->setMailingListID($mailingListID)
            ->setNumberOfUploadedAddresses($numberOfUploadedAddresses)
            ->setNumberOfValidAddresses($numberOfValidAddresses)
            ->setNumberOfApprovedAddresses($numberOfApprovedAddresses)
            ->setNumberOfForceThroughAddresses($numberOfForceThroughAddresses)
            ->setNumberOfFailedAddresses($numberOfFailedAddresses)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get UploadMailingListResult value
     * @return bool
     */
    public function getUploadMailingListResult()
    {
        return $this->UploadMailingListResult;
    }
    /**
     * Set UploadMailingListResult value
     * @param bool $uploadMailingListResult
     * @return \StructType\UploadMailingListResponse
     */
    public function setUploadMailingListResult($uploadMailingListResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($uploadMailingListResult) && !is_bool($uploadMailingListResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uploadMailingListResult, true), gettype($uploadMailingListResult)), __LINE__);
        }
        $this->UploadMailingListResult = $uploadMailingListResult;
        return $this;
    }
    /**
     * Get MailingListID value
     * @return int
     */
    public function getMailingListID()
    {
        return $this->MailingListID;
    }
    /**
     * Set MailingListID value
     * @param int $mailingListID
     * @return \StructType\UploadMailingListResponse
     */
    public function setMailingListID($mailingListID = null)
    {
        // validation for constraint: int
        if (!is_null($mailingListID) && !(is_int($mailingListID) || ctype_digit($mailingListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mailingListID, true), gettype($mailingListID)), __LINE__);
        }
        $this->MailingListID = $mailingListID;
        return $this;
    }
    /**
     * Get NumberOfUploadedAddresses value
     * @return int
     */
    public function getNumberOfUploadedAddresses()
    {
        return $this->NumberOfUploadedAddresses;
    }
    /**
     * Set NumberOfUploadedAddresses value
     * @param int $numberOfUploadedAddresses
     * @return \StructType\UploadMailingListResponse
     */
    public function setNumberOfUploadedAddresses($numberOfUploadedAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUploadedAddresses) && !(is_int($numberOfUploadedAddresses) || ctype_digit($numberOfUploadedAddresses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUploadedAddresses, true), gettype($numberOfUploadedAddresses)), __LINE__);
        }
        $this->NumberOfUploadedAddresses = $numberOfUploadedAddresses;
        return $this;
    }
    /**
     * Get NumberOfValidAddresses value
     * @return int
     */
    public function getNumberOfValidAddresses()
    {
        return $this->NumberOfValidAddresses;
    }
    /**
     * Set NumberOfValidAddresses value
     * @param int $numberOfValidAddresses
     * @return \StructType\UploadMailingListResponse
     */
    public function setNumberOfValidAddresses($numberOfValidAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfValidAddresses) && !(is_int($numberOfValidAddresses) || ctype_digit($numberOfValidAddresses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfValidAddresses, true), gettype($numberOfValidAddresses)), __LINE__);
        }
        $this->NumberOfValidAddresses = $numberOfValidAddresses;
        return $this;
    }
    /**
     * Get NumberOfApprovedAddresses value
     * @return int
     */
    public function getNumberOfApprovedAddresses()
    {
        return $this->NumberOfApprovedAddresses;
    }
    /**
     * Set NumberOfApprovedAddresses value
     * @param int $numberOfApprovedAddresses
     * @return \StructType\UploadMailingListResponse
     */
    public function setNumberOfApprovedAddresses($numberOfApprovedAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfApprovedAddresses) && !(is_int($numberOfApprovedAddresses) || ctype_digit($numberOfApprovedAddresses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfApprovedAddresses, true), gettype($numberOfApprovedAddresses)), __LINE__);
        }
        $this->NumberOfApprovedAddresses = $numberOfApprovedAddresses;
        return $this;
    }
    /**
     * Get NumberOfForceThroughAddresses value
     * @return int
     */
    public function getNumberOfForceThroughAddresses()
    {
        return $this->NumberOfForceThroughAddresses;
    }
    /**
     * Set NumberOfForceThroughAddresses value
     * @param int $numberOfForceThroughAddresses
     * @return \StructType\UploadMailingListResponse
     */
    public function setNumberOfForceThroughAddresses($numberOfForceThroughAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfForceThroughAddresses) && !(is_int($numberOfForceThroughAddresses) || ctype_digit($numberOfForceThroughAddresses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfForceThroughAddresses, true), gettype($numberOfForceThroughAddresses)), __LINE__);
        }
        $this->NumberOfForceThroughAddresses = $numberOfForceThroughAddresses;
        return $this;
    }
    /**
     * Get NumberOfFailedAddresses value
     * @return int
     */
    public function getNumberOfFailedAddresses()
    {
        return $this->NumberOfFailedAddresses;
    }
    /**
     * Set NumberOfFailedAddresses value
     * @param int $numberOfFailedAddresses
     * @return \StructType\UploadMailingListResponse
     */
    public function setNumberOfFailedAddresses($numberOfFailedAddresses = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfFailedAddresses) && !(is_int($numberOfFailedAddresses) || ctype_digit($numberOfFailedAddresses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfFailedAddresses, true), gettype($numberOfFailedAddresses)), __LINE__);
        }
        $this->NumberOfFailedAddresses = $numberOfFailedAddresses;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \StructType\UploadMailingListResponse
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
