<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadDocument StructType
 * @subpackage Structs
 */
class UploadDocument extends AbstractStructBase
{
    /**
     * The Colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Colour;
    /**
     * The DoubleSided
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DoubleSided;
    /**
     * The LetterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LetterID;
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The sDocumentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sDocumentName;
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentData;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for UploadDocument
     * @uses UploadDocument::setColour()
     * @uses UploadDocument::setDoubleSided()
     * @uses UploadDocument::setLetterID()
     * @uses UploadDocument::setSLoginToken()
     * @uses UploadDocument::setSDocumentName()
     * @uses UploadDocument::setDocumentData()
     * @uses UploadDocument::setSReturnMessage()
     * @param bool $colour
     * @param bool $doubleSided
     * @param int $letterID
     * @param string $sLoginToken
     * @param string $sDocumentName
     * @param string $documentData
     * @param string $sReturnMessage
     */
    public function __construct($colour = null, $doubleSided = null, $letterID = null, $sLoginToken = null, $sDocumentName = null, $documentData = null, $sReturnMessage = null)
    {
        $this
            ->setColour($colour)
            ->setDoubleSided($doubleSided)
            ->setLetterID($letterID)
            ->setSLoginToken($sLoginToken)
            ->setSDocumentName($sDocumentName)
            ->setDocumentData($documentData)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get Colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->Colour;
    }
    /**
     * Set Colour value
     * @param bool $colour
     * @return \StructType\UploadDocument
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->Colour = $colour;
        return $this;
    }
    /**
     * Get DoubleSided value
     * @return bool
     */
    public function getDoubleSided()
    {
        return $this->DoubleSided;
    }
    /**
     * Set DoubleSided value
     * @param bool $doubleSided
     * @return \StructType\UploadDocument
     */
    public function setDoubleSided($doubleSided = null)
    {
        // validation for constraint: boolean
        if (!is_null($doubleSided) && !is_bool($doubleSided)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doubleSided, true), gettype($doubleSided)), __LINE__);
        }
        $this->DoubleSided = $doubleSided;
        return $this;
    }
    /**
     * Get LetterID value
     * @return int
     */
    public function getLetterID()
    {
        return $this->LetterID;
    }
    /**
     * Set LetterID value
     * @param int $letterID
     * @return \StructType\UploadDocument
     */
    public function setLetterID($letterID = null)
    {
        // validation for constraint: int
        if (!is_null($letterID) && !(is_int($letterID) || ctype_digit($letterID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterID, true), gettype($letterID)), __LINE__);
        }
        $this->LetterID = $letterID;
        return $this;
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \StructType\UploadDocument
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get sDocumentName value
     * @return string|null
     */
    public function getSDocumentName()
    {
        return $this->sDocumentName;
    }
    /**
     * Set sDocumentName value
     * @param string $sDocumentName
     * @return \StructType\UploadDocument
     */
    public function setSDocumentName($sDocumentName = null)
    {
        // validation for constraint: string
        if (!is_null($sDocumentName) && !is_string($sDocumentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sDocumentName, true), gettype($sDocumentName)), __LINE__);
        }
        $this->sDocumentName = $sDocumentName;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @param string $documentData
     * @return \StructType\UploadDocument
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \StructType\UploadDocument
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
