<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendPostcardToFindNearestResponse StructType
 * @subpackage Structs
 */
class SendPostcardToFindNearestResponse extends AbstractStructBase
{
    /**
     * The SendPostcardToFindNearestResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendPostcardToFindNearestResult;
    /**
     * The costOfMailing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $costOfMailing;
    /**
     * The numberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfPages;
    /**
     * The numberOfSheets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfSheets;
    /**
     * The numberOfAddressesSentTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesSentTo;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for SendPostcardToFindNearestResponse
     * @uses SendPostcardToFindNearestResponse::setSendPostcardToFindNearestResult()
     * @uses SendPostcardToFindNearestResponse::setCostOfMailing()
     * @uses SendPostcardToFindNearestResponse::setNumberOfPages()
     * @uses SendPostcardToFindNearestResponse::setNumberOfSheets()
     * @uses SendPostcardToFindNearestResponse::setNumberOfAddressesSentTo()
     * @uses SendPostcardToFindNearestResponse::setReturnMessage()
     * @param bool $sendPostcardToFindNearestResult
     * @param float $costOfMailing
     * @param int $numberOfPages
     * @param int $numberOfSheets
     * @param int $numberOfAddressesSentTo
     * @param string $returnMessage
     */
    public function __construct($sendPostcardToFindNearestResult = null, $costOfMailing = null, $numberOfPages = null, $numberOfSheets = null, $numberOfAddressesSentTo = null, $returnMessage = null)
    {
        $this
            ->setSendPostcardToFindNearestResult($sendPostcardToFindNearestResult)
            ->setCostOfMailing($costOfMailing)
            ->setNumberOfPages($numberOfPages)
            ->setNumberOfSheets($numberOfSheets)
            ->setNumberOfAddressesSentTo($numberOfAddressesSentTo)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get SendPostcardToFindNearestResult value
     * @return bool
     */
    public function getSendPostcardToFindNearestResult()
    {
        return $this->SendPostcardToFindNearestResult;
    }
    /**
     * Set SendPostcardToFindNearestResult value
     * @param bool $sendPostcardToFindNearestResult
     * @return \StructType\SendPostcardToFindNearestResponse
     */
    public function setSendPostcardToFindNearestResult($sendPostcardToFindNearestResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendPostcardToFindNearestResult) && !is_bool($sendPostcardToFindNearestResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendPostcardToFindNearestResult, true), gettype($sendPostcardToFindNearestResult)), __LINE__);
        }
        $this->SendPostcardToFindNearestResult = $sendPostcardToFindNearestResult;
        return $this;
    }
    /**
     * Get costOfMailing value
     * @return float
     */
    public function getCostOfMailing()
    {
        return $this->costOfMailing;
    }
    /**
     * Set costOfMailing value
     * @param float $costOfMailing
     * @return \StructType\SendPostcardToFindNearestResponse
     */
    public function setCostOfMailing($costOfMailing = null)
    {
        // validation for constraint: float
        if (!is_null($costOfMailing) && !(is_float($costOfMailing) || is_numeric($costOfMailing))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfMailing, true), gettype($costOfMailing)), __LINE__);
        }
        $this->costOfMailing = $costOfMailing;
        return $this;
    }
    /**
     * Get numberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->numberOfPages;
    }
    /**
     * Set numberOfPages value
     * @param int $numberOfPages
     * @return \StructType\SendPostcardToFindNearestResponse
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->numberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get numberOfSheets value
     * @return int
     */
    public function getNumberOfSheets()
    {
        return $this->numberOfSheets;
    }
    /**
     * Set numberOfSheets value
     * @param int $numberOfSheets
     * @return \StructType\SendPostcardToFindNearestResponse
     */
    public function setNumberOfSheets($numberOfSheets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSheets) && !(is_int($numberOfSheets) || ctype_digit($numberOfSheets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSheets, true), gettype($numberOfSheets)), __LINE__);
        }
        $this->numberOfSheets = $numberOfSheets;
        return $this;
    }
    /**
     * Get numberOfAddressesSentTo value
     * @return int
     */
    public function getNumberOfAddressesSentTo()
    {
        return $this->numberOfAddressesSentTo;
    }
    /**
     * Set numberOfAddressesSentTo value
     * @param int $numberOfAddressesSentTo
     * @return \StructType\SendPostcardToFindNearestResponse
     */
    public function setNumberOfAddressesSentTo($numberOfAddressesSentTo = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesSentTo) && !(is_int($numberOfAddressesSentTo) || ctype_digit($numberOfAddressesSentTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesSentTo, true), gettype($numberOfAddressesSentTo)), __LINE__);
        }
        $this->numberOfAddressesSentTo = $numberOfAddressesSentTo;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \StructType\SendPostcardToFindNearestResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
