<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendDriverMailingConfirmation StructType
 * @subpackage Structs
 */
class SendDriverMailingConfirmation extends AbstractStructBase
{
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * The quantityFailed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantityFailed;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $cost;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The mailingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailingName;
    /**
     * The failedAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $failedAddresses;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for SendDriverMailingConfirmation
     * @uses SendDriverMailingConfirmation::setQuantity()
     * @uses SendDriverMailingConfirmation::setQuantityFailed()
     * @uses SendDriverMailingConfirmation::setCost()
     * @uses SendDriverMailingConfirmation::setLoginToken()
     * @uses SendDriverMailingConfirmation::setMailingName()
     * @uses SendDriverMailingConfirmation::setFailedAddresses()
     * @uses SendDriverMailingConfirmation::setReturnMessage()
     * @param int $quantity
     * @param int $quantityFailed
     * @param float $cost
     * @param string $loginToken
     * @param string $mailingName
     * @param string $failedAddresses
     * @param string $returnMessage
     */
    public function __construct($quantity = null, $quantityFailed = null, $cost = null, $loginToken = null, $mailingName = null, $failedAddresses = null, $returnMessage = null)
    {
        $this
            ->setQuantity($quantity)
            ->setQuantityFailed($quantityFailed)
            ->setCost($cost)
            ->setLoginToken($loginToken)
            ->setMailingName($mailingName)
            ->setFailedAddresses($failedAddresses)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\SendDriverMailingConfirmation
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get quantityFailed value
     * @return int
     */
    public function getQuantityFailed()
    {
        return $this->quantityFailed;
    }
    /**
     * Set quantityFailed value
     * @param int $quantityFailed
     * @return \StructType\SendDriverMailingConfirmation
     */
    public function setQuantityFailed($quantityFailed = null)
    {
        // validation for constraint: int
        if (!is_null($quantityFailed) && !(is_int($quantityFailed) || ctype_digit($quantityFailed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityFailed, true), gettype($quantityFailed)), __LINE__);
        }
        $this->quantityFailed = $quantityFailed;
        return $this;
    }
    /**
     * Get cost value
     * @return float
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\SendDriverMailingConfirmation
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \StructType\SendDriverMailingConfirmation
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get mailingName value
     * @return string|null
     */
    public function getMailingName()
    {
        return $this->mailingName;
    }
    /**
     * Set mailingName value
     * @param string $mailingName
     * @return \StructType\SendDriverMailingConfirmation
     */
    public function setMailingName($mailingName = null)
    {
        // validation for constraint: string
        if (!is_null($mailingName) && !is_string($mailingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingName, true), gettype($mailingName)), __LINE__);
        }
        $this->mailingName = $mailingName;
        return $this;
    }
    /**
     * Get failedAddresses value
     * @return string|null
     */
    public function getFailedAddresses()
    {
        return $this->failedAddresses;
    }
    /**
     * Set failedAddresses value
     * @param string $failedAddresses
     * @return \StructType\SendDriverMailingConfirmation
     */
    public function setFailedAddresses($failedAddresses = null)
    {
        // validation for constraint: string
        if (!is_null($failedAddresses) && !is_string($failedAddresses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failedAddresses, true), gettype($failedAddresses)), __LINE__);
        }
        $this->failedAddresses = $failedAddresses;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \StructType\SendDriverMailingConfirmation
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
