<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewLibraryLetterhead StructType
 * @subpackage Structs
 */
class PreviewLibraryLetterhead extends AbstractStructBase
{
    /**
     * The letterheadId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $letterheadId;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The letterheadData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $letterheadData;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for PreviewLibraryLetterhead
     * @uses PreviewLibraryLetterhead::setLetterheadId()
     * @uses PreviewLibraryLetterhead::setLoginToken()
     * @uses PreviewLibraryLetterhead::setFormat()
     * @uses PreviewLibraryLetterhead::setLetterheadData()
     * @uses PreviewLibraryLetterhead::setReturnMessage()
     * @param int $letterheadId
     * @param string $loginToken
     * @param string $format
     * @param string $letterheadData
     * @param string $returnMessage
     */
    public function __construct($letterheadId = null, $loginToken = null, $format = null, $letterheadData = null, $returnMessage = null)
    {
        $this
            ->setLetterheadId($letterheadId)
            ->setLoginToken($loginToken)
            ->setFormat($format)
            ->setLetterheadData($letterheadData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get letterheadId value
     * @return int
     */
    public function getLetterheadId()
    {
        return $this->letterheadId;
    }
    /**
     * Set letterheadId value
     * @param int $letterheadId
     * @return \StructType\PreviewLibraryLetterhead
     */
    public function setLetterheadId($letterheadId = null)
    {
        // validation for constraint: int
        if (!is_null($letterheadId) && !(is_int($letterheadId) || ctype_digit($letterheadId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterheadId, true), gettype($letterheadId)), __LINE__);
        }
        $this->letterheadId = $letterheadId;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \StructType\PreviewLibraryLetterhead
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\PreviewLibraryLetterhead
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get letterheadData value
     * @return string|null
     */
    public function getLetterheadData()
    {
        return $this->letterheadData;
    }
    /**
     * Set letterheadData value
     * @param string $letterheadData
     * @return \StructType\PreviewLibraryLetterhead
     */
    public function setLetterheadData($letterheadData = null)
    {
        // validation for constraint: string
        if (!is_null($letterheadData) && !is_string($letterheadData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letterheadData, true), gettype($letterheadData)), __LINE__);
        }
        $this->letterheadData = $letterheadData;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \StructType\PreviewLibraryLetterhead
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
