<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Letterhead StructType
 * @subpackage Structs
 */
class Letterhead extends AbstractStructBase
{
    /**
     * The LetterheadId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LetterheadId;
    /**
     * The IsShared
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsShared;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Letterhead
     * @uses Letterhead::setLetterheadId()
     * @uses Letterhead::setIsShared()
     * @uses Letterhead::setName()
     * @uses Letterhead::setDescription()
     * @param int $letterheadId
     * @param bool $isShared
     * @param string $name
     * @param string $description
     */
    public function __construct($letterheadId = null, $isShared = null, $name = null, $description = null)
    {
        $this
            ->setLetterheadId($letterheadId)
            ->setIsShared($isShared)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get LetterheadId value
     * @return int
     */
    public function getLetterheadId()
    {
        return $this->LetterheadId;
    }
    /**
     * Set LetterheadId value
     * @param int $letterheadId
     * @return \StructType\Letterhead
     */
    public function setLetterheadId($letterheadId = null)
    {
        // validation for constraint: int
        if (!is_null($letterheadId) && !(is_int($letterheadId) || ctype_digit($letterheadId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterheadId, true), gettype($letterheadId)), __LINE__);
        }
        $this->LetterheadId = $letterheadId;
        return $this;
    }
    /**
     * Get IsShared value
     * @return bool
     */
    public function getIsShared()
    {
        return $this->IsShared;
    }
    /**
     * Set IsShared value
     * @param bool $isShared
     * @return \StructType\Letterhead
     */
    public function setIsShared($isShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShared) && !is_bool($isShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShared, true), gettype($isShared)), __LINE__);
        }
        $this->IsShared = $isShared;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Letterhead
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Letterhead
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
