<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLibraryLetters StructType
 * @subpackage Structs
 */
class GetLibraryLetters extends AbstractStructBase
{
    /**
     * The letterType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $letterType;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The searchDocumentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $searchDocumentName;
    /**
     * The letters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $letters;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetLibraryLetters
     * @uses GetLibraryLetters::setLetterType()
     * @uses GetLibraryLetters::setLoginToken()
     * @uses GetLibraryLetters::setSearchDocumentName()
     * @uses GetLibraryLetters::setLetters()
     * @uses GetLibraryLetters::setReturnMessage()
     * @param string $letterType
     * @param string $loginToken
     * @param string $searchDocumentName
     * @param \ArrayType\ArrayOfAnyType $letters
     * @param string $returnMessage
     */
    public function __construct($letterType = null, $loginToken = null, $searchDocumentName = null, \ArrayType\ArrayOfAnyType $letters = null, $returnMessage = null)
    {
        $this
            ->setLetterType($letterType)
            ->setLoginToken($loginToken)
            ->setSearchDocumentName($searchDocumentName)
            ->setLetters($letters)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get letterType value
     * @return string
     */
    public function getLetterType()
    {
        return $this->letterType;
    }
    /**
     * Set letterType value
     * @uses \EnumType\APILetterType::valueIsValid()
     * @uses \EnumType\APILetterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $letterType
     * @return \StructType\GetLibraryLetters
     */
    public function setLetterType($letterType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\APILetterType::valueIsValid($letterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\APILetterType', is_array($letterType) ? implode(', ', $letterType) : var_export($letterType, true), implode(', ', \EnumType\APILetterType::getValidValues())), __LINE__);
        }
        $this->letterType = $letterType;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \StructType\GetLibraryLetters
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get searchDocumentName value
     * @return string|null
     */
    public function getSearchDocumentName()
    {
        return $this->searchDocumentName;
    }
    /**
     * Set searchDocumentName value
     * @param string $searchDocumentName
     * @return \StructType\GetLibraryLetters
     */
    public function setSearchDocumentName($searchDocumentName = null)
    {
        // validation for constraint: string
        if (!is_null($searchDocumentName) && !is_string($searchDocumentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchDocumentName, true), gettype($searchDocumentName)), __LINE__);
        }
        $this->searchDocumentName = $searchDocumentName;
        return $this;
    }
    /**
     * Get letters value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getLetters()
    {
        return $this->letters;
    }
    /**
     * Set letters value
     * @param \ArrayType\ArrayOfAnyType $letters
     * @return \StructType\GetLibraryLetters
     */
    public function setLetters(\ArrayType\ArrayOfAnyType $letters = null)
    {
        $this->letters = $letters;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \StructType\GetLibraryLetters
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
