<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLetterByID StructType
 * @subpackage Structs
 */
class GetLetterByID extends AbstractStructBase
{
    /**
     * The LetterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LetterID;
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * The returnLetter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerAPILetter
     */
    public $returnLetter;
    /**
     * Constructor method for GetLetterByID
     * @uses GetLetterByID::setLetterID()
     * @uses GetLetterByID::setSLoginToken()
     * @uses GetLetterByID::setSReturnMessage()
     * @uses GetLetterByID::setReturnLetter()
     * @param int $letterID
     * @param string $sLoginToken
     * @param string $sReturnMessage
     * @param \StructType\CustomerAPILetter $returnLetter
     */
    public function __construct($letterID = null, $sLoginToken = null, $sReturnMessage = null, \StructType\CustomerAPILetter $returnLetter = null)
    {
        $this
            ->setLetterID($letterID)
            ->setSLoginToken($sLoginToken)
            ->setSReturnMessage($sReturnMessage)
            ->setReturnLetter($returnLetter);
    }
    /**
     * Get LetterID value
     * @return int
     */
    public function getLetterID()
    {
        return $this->LetterID;
    }
    /**
     * Set LetterID value
     * @param int $letterID
     * @return \StructType\GetLetterByID
     */
    public function setLetterID($letterID = null)
    {
        // validation for constraint: int
        if (!is_null($letterID) && !(is_int($letterID) || ctype_digit($letterID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterID, true), gettype($letterID)), __LINE__);
        }
        $this->LetterID = $letterID;
        return $this;
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \StructType\GetLetterByID
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \StructType\GetLetterByID
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
    /**
     * Get returnLetter value
     * @return \StructType\CustomerAPILetter|null
     */
    public function getReturnLetter()
    {
        return $this->returnLetter;
    }
    /**
     * Set returnLetter value
     * @param \StructType\CustomerAPILetter $returnLetter
     * @return \StructType\GetLetterByID
     */
    public function setReturnLetter(\StructType\CustomerAPILetter $returnLetter = null)
    {
        $this->returnLetter = $returnLetter;
        return $this;
    }
}
