<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocumentStickerArea StructType
 * @subpackage Structs
 */
class GetDocumentStickerArea extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The area
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RectangleF
     */
    public $area;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetDocumentStickerArea
     * @uses GetDocumentStickerArea::setDocumentType()
     * @uses GetDocumentStickerArea::setArea()
     * @uses GetDocumentStickerArea::setReturnMessage()
     * @param string $documentType
     * @param \StructType\RectangleF $area
     * @param string $returnMessage
     */
    public function __construct($documentType = null, \StructType\RectangleF $area = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setArea($area)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \EnumType\DocumentType::valueIsValid()
     * @uses \EnumType\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \StructType\GetDocumentStickerArea
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \EnumType\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get area value
     * @return \StructType\RectangleF
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param \StructType\RectangleF $area
     * @return \StructType\GetDocumentStickerArea
     */
    public function setArea(\StructType\RectangleF $area = null)
    {
        $this->area = $area;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \StructType\GetDocumentStickerArea
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
