<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteMapping StructType
 * @subpackage Structs
 */
class DeleteMapping extends AbstractStructBase
{
    /**
     * The mappingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mappingID;
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for DeleteMapping
     * @uses DeleteMapping::setMappingID()
     * @uses DeleteMapping::setSLoginToken()
     * @uses DeleteMapping::setSReturnMessage()
     * @param int $mappingID
     * @param string $sLoginToken
     * @param string $sReturnMessage
     */
    public function __construct($mappingID = null, $sLoginToken = null, $sReturnMessage = null)
    {
        $this
            ->setMappingID($mappingID)
            ->setSLoginToken($sLoginToken)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get mappingID value
     * @return int
     */
    public function getMappingID()
    {
        return $this->mappingID;
    }
    /**
     * Set mappingID value
     * @param int $mappingID
     * @return \StructType\DeleteMapping
     */
    public function setMappingID($mappingID = null)
    {
        // validation for constraint: int
        if (!is_null($mappingID) && !(is_int($mappingID) || ctype_digit($mappingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mappingID, true), gettype($mappingID)), __LINE__);
        }
        $this->mappingID = $mappingID;
        return $this;
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \StructType\DeleteMapping
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \StructType\DeleteMapping
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
