<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePriceBandResponse StructType
 * @subpackage Structs
 */
class CreatePriceBandResponse extends AbstractStructBase
{
    /**
     * The CreatePriceBandResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CreatePriceBandResult;
    /**
     * The PriceBandId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriceBandId;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for CreatePriceBandResponse
     * @uses CreatePriceBandResponse::setCreatePriceBandResult()
     * @uses CreatePriceBandResponse::setPriceBandId()
     * @uses CreatePriceBandResponse::setSReturnMessage()
     * @param bool $createPriceBandResult
     * @param int $priceBandId
     * @param string $sReturnMessage
     */
    public function __construct($createPriceBandResult = null, $priceBandId = null, $sReturnMessage = null)
    {
        $this
            ->setCreatePriceBandResult($createPriceBandResult)
            ->setPriceBandId($priceBandId)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get CreatePriceBandResult value
     * @return bool
     */
    public function getCreatePriceBandResult()
    {
        return $this->CreatePriceBandResult;
    }
    /**
     * Set CreatePriceBandResult value
     * @param bool $createPriceBandResult
     * @return \StructType\CreatePriceBandResponse
     */
    public function setCreatePriceBandResult($createPriceBandResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($createPriceBandResult) && !is_bool($createPriceBandResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createPriceBandResult, true), gettype($createPriceBandResult)), __LINE__);
        }
        $this->CreatePriceBandResult = $createPriceBandResult;
        return $this;
    }
    /**
     * Get PriceBandId value
     * @return int
     */
    public function getPriceBandId()
    {
        return $this->PriceBandId;
    }
    /**
     * Set PriceBandId value
     * @param int $priceBandId
     * @return \StructType\CreatePriceBandResponse
     */
    public function setPriceBandId($priceBandId = null)
    {
        // validation for constraint: int
        if (!is_null($priceBandId) && !(is_int($priceBandId) || ctype_digit($priceBandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceBandId, true), gettype($priceBandId)), __LINE__);
        }
        $this->PriceBandId = $priceBandId;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \StructType\CreatePriceBandResponse
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
