<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAttachment StructType
 * @subpackage Structs
 */
class CreateAttachment extends AbstractStructBase
{
    /**
     * The shareAttachmentWithGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $shareAttachmentWithGroup;
    /**
     * The attachmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $attachmentID;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fileContents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileContents;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CreateAttachment
     * @uses CreateAttachment::setShareAttachmentWithGroup()
     * @uses CreateAttachment::setAttachmentID()
     * @uses CreateAttachment::setLoginToken()
     * @uses CreateAttachment::setName()
     * @uses CreateAttachment::setDescription()
     * @uses CreateAttachment::setFileContents()
     * @uses CreateAttachment::setReturnMessage()
     * @param bool $shareAttachmentWithGroup
     * @param int $attachmentID
     * @param string $loginToken
     * @param string $name
     * @param string $description
     * @param string $fileContents
     * @param string $returnMessage
     */
    public function __construct($shareAttachmentWithGroup = null, $attachmentID = null, $loginToken = null, $name = null, $description = null, $fileContents = null, $returnMessage = null)
    {
        $this
            ->setShareAttachmentWithGroup($shareAttachmentWithGroup)
            ->setAttachmentID($attachmentID)
            ->setLoginToken($loginToken)
            ->setName($name)
            ->setDescription($description)
            ->setFileContents($fileContents)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get shareAttachmentWithGroup value
     * @return bool
     */
    public function getShareAttachmentWithGroup()
    {
        return $this->shareAttachmentWithGroup;
    }
    /**
     * Set shareAttachmentWithGroup value
     * @param bool $shareAttachmentWithGroup
     * @return \StructType\CreateAttachment
     */
    public function setShareAttachmentWithGroup($shareAttachmentWithGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($shareAttachmentWithGroup) && !is_bool($shareAttachmentWithGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shareAttachmentWithGroup, true), gettype($shareAttachmentWithGroup)), __LINE__);
        }
        $this->shareAttachmentWithGroup = $shareAttachmentWithGroup;
        return $this;
    }
    /**
     * Get attachmentID value
     * @return int
     */
    public function getAttachmentID()
    {
        return $this->attachmentID;
    }
    /**
     * Set attachmentID value
     * @param int $attachmentID
     * @return \StructType\CreateAttachment
     */
    public function setAttachmentID($attachmentID = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentID) && !(is_int($attachmentID) || ctype_digit($attachmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachmentID, true), gettype($attachmentID)), __LINE__);
        }
        $this->attachmentID = $attachmentID;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \StructType\CreateAttachment
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CreateAttachment
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CreateAttachment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fileContents value
     * @return string|null
     */
    public function getFileContents()
    {
        return $this->fileContents;
    }
    /**
     * Set fileContents value
     * @param string $fileContents
     * @return \StructType\CreateAttachment
     */
    public function setFileContents($fileContents = null)
    {
        // validation for constraint: string
        if (!is_null($fileContents) && !is_string($fileContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContents, true), gettype($fileContents)), __LINE__);
        }
        $this->fileContents = $fileContents;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \StructType\CreateAttachment
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
