<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateLetterCostSimpleBatch StructType
 * @subpackage Structs
 */
class CalculateLetterCostSimpleBatch extends AbstractStructBase
{
    /**
     * The bColour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bColour;
    /**
     * The bDoubleSided
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bDoubleSided;
    /**
     * The iNumberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $iNumberOfPages;
    /**
     * The iNumberOfLetters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $iNumberOfLetters;
    /**
     * The dNetCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $dNetCost;
    /**
     * The dVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $dVAT;
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for CalculateLetterCostSimpleBatch
     * @uses CalculateLetterCostSimpleBatch::setBColour()
     * @uses CalculateLetterCostSimpleBatch::setBDoubleSided()
     * @uses CalculateLetterCostSimpleBatch::setINumberOfPages()
     * @uses CalculateLetterCostSimpleBatch::setINumberOfLetters()
     * @uses CalculateLetterCostSimpleBatch::setDNetCost()
     * @uses CalculateLetterCostSimpleBatch::setDVAT()
     * @uses CalculateLetterCostSimpleBatch::setSLoginToken()
     * @uses CalculateLetterCostSimpleBatch::setSReturnMessage()
     * @param bool $bColour
     * @param bool $bDoubleSided
     * @param int $iNumberOfPages
     * @param int $iNumberOfLetters
     * @param float $dNetCost
     * @param float $dVAT
     * @param string $sLoginToken
     * @param string $sReturnMessage
     */
    public function __construct($bColour = null, $bDoubleSided = null, $iNumberOfPages = null, $iNumberOfLetters = null, $dNetCost = null, $dVAT = null, $sLoginToken = null, $sReturnMessage = null)
    {
        $this
            ->setBColour($bColour)
            ->setBDoubleSided($bDoubleSided)
            ->setINumberOfPages($iNumberOfPages)
            ->setINumberOfLetters($iNumberOfLetters)
            ->setDNetCost($dNetCost)
            ->setDVAT($dVAT)
            ->setSLoginToken($sLoginToken)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get bColour value
     * @return bool
     */
    public function getBColour()
    {
        return $this->bColour;
    }
    /**
     * Set bColour value
     * @param bool $bColour
     * @return \StructType\CalculateLetterCostSimpleBatch
     */
    public function setBColour($bColour = null)
    {
        // validation for constraint: boolean
        if (!is_null($bColour) && !is_bool($bColour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bColour, true), gettype($bColour)), __LINE__);
        }
        $this->bColour = $bColour;
        return $this;
    }
    /**
     * Get bDoubleSided value
     * @return bool
     */
    public function getBDoubleSided()
    {
        return $this->bDoubleSided;
    }
    /**
     * Set bDoubleSided value
     * @param bool $bDoubleSided
     * @return \StructType\CalculateLetterCostSimpleBatch
     */
    public function setBDoubleSided($bDoubleSided = null)
    {
        // validation for constraint: boolean
        if (!is_null($bDoubleSided) && !is_bool($bDoubleSided)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bDoubleSided, true), gettype($bDoubleSided)), __LINE__);
        }
        $this->bDoubleSided = $bDoubleSided;
        return $this;
    }
    /**
     * Get iNumberOfPages value
     * @return int
     */
    public function getINumberOfPages()
    {
        return $this->iNumberOfPages;
    }
    /**
     * Set iNumberOfPages value
     * @param int $iNumberOfPages
     * @return \StructType\CalculateLetterCostSimpleBatch
     */
    public function setINumberOfPages($iNumberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($iNumberOfPages) && !(is_int($iNumberOfPages) || ctype_digit($iNumberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iNumberOfPages, true), gettype($iNumberOfPages)), __LINE__);
        }
        $this->iNumberOfPages = $iNumberOfPages;
        return $this;
    }
    /**
     * Get iNumberOfLetters value
     * @return int
     */
    public function getINumberOfLetters()
    {
        return $this->iNumberOfLetters;
    }
    /**
     * Set iNumberOfLetters value
     * @param int $iNumberOfLetters
     * @return \StructType\CalculateLetterCostSimpleBatch
     */
    public function setINumberOfLetters($iNumberOfLetters = null)
    {
        // validation for constraint: int
        if (!is_null($iNumberOfLetters) && !(is_int($iNumberOfLetters) || ctype_digit($iNumberOfLetters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iNumberOfLetters, true), gettype($iNumberOfLetters)), __LINE__);
        }
        $this->iNumberOfLetters = $iNumberOfLetters;
        return $this;
    }
    /**
     * Get dNetCost value
     * @return float
     */
    public function getDNetCost()
    {
        return $this->dNetCost;
    }
    /**
     * Set dNetCost value
     * @param float $dNetCost
     * @return \StructType\CalculateLetterCostSimpleBatch
     */
    public function setDNetCost($dNetCost = null)
    {
        // validation for constraint: float
        if (!is_null($dNetCost) && !(is_float($dNetCost) || is_numeric($dNetCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dNetCost, true), gettype($dNetCost)), __LINE__);
        }
        $this->dNetCost = $dNetCost;
        return $this;
    }
    /**
     * Get dVAT value
     * @return float
     */
    public function getDVAT()
    {
        return $this->dVAT;
    }
    /**
     * Set dVAT value
     * @param float $dVAT
     * @return \StructType\CalculateLetterCostSimpleBatch
     */
    public function setDVAT($dVAT = null)
    {
        // validation for constraint: float
        if (!is_null($dVAT) && !(is_float($dVAT) || is_numeric($dVAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dVAT, true), gettype($dVAT)), __LINE__);
        }
        $this->dVAT = $dVAT;
        return $this;
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \StructType\CalculateLetterCostSimpleBatch
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \StructType\CalculateLetterCostSimpleBatch
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
