<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateCostOfDataListResponse StructType
 * @subpackage Structs
 */
class CalculateCostOfDataListResponse extends AbstractStructBase
{
    /**
     * The CalculateCostOfDataListResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CalculateCostOfDataListResult;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $cost;
    /**
     * The individualCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $individualCost;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CalculateCostOfDataListResponse
     * @uses CalculateCostOfDataListResponse::setCalculateCostOfDataListResult()
     * @uses CalculateCostOfDataListResponse::setCost()
     * @uses CalculateCostOfDataListResponse::setIndividualCost()
     * @uses CalculateCostOfDataListResponse::setReturnMessage()
     * @param bool $calculateCostOfDataListResult
     * @param float $cost
     * @param float $individualCost
     * @param string $returnMessage
     */
    public function __construct($calculateCostOfDataListResult = null, $cost = null, $individualCost = null, $returnMessage = null)
    {
        $this
            ->setCalculateCostOfDataListResult($calculateCostOfDataListResult)
            ->setCost($cost)
            ->setIndividualCost($individualCost)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get CalculateCostOfDataListResult value
     * @return bool
     */
    public function getCalculateCostOfDataListResult()
    {
        return $this->CalculateCostOfDataListResult;
    }
    /**
     * Set CalculateCostOfDataListResult value
     * @param bool $calculateCostOfDataListResult
     * @return \StructType\CalculateCostOfDataListResponse
     */
    public function setCalculateCostOfDataListResult($calculateCostOfDataListResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateCostOfDataListResult) && !is_bool($calculateCostOfDataListResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculateCostOfDataListResult, true), gettype($calculateCostOfDataListResult)), __LINE__);
        }
        $this->CalculateCostOfDataListResult = $calculateCostOfDataListResult;
        return $this;
    }
    /**
     * Get cost value
     * @return float
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\CalculateCostOfDataListResponse
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get individualCost value
     * @return float
     */
    public function getIndividualCost()
    {
        return $this->individualCost;
    }
    /**
     * Set individualCost value
     * @param float $individualCost
     * @return \StructType\CalculateCostOfDataListResponse
     */
    public function setIndividualCost($individualCost = null)
    {
        // validation for constraint: float
        if (!is_null($individualCost) && !(is_float($individualCost) || is_numeric($individualCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($individualCost, true), gettype($individualCost)), __LINE__);
        }
        $this->individualCost = $individualCost;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \StructType\CalculateCostOfDataListResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
