<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UploadDocument
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to upload a PDF document. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter Name you supply will be used to display your letter. The DocumentData
     * parameter must contain your PDF as a Base64-encoded byte array. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure. The LetterID is populated with the new record
     * ID once the letter has been uploaded.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadDocument $parameters
     * @return \StructType\UploadDocumentResponse|bool
     */
    public function UploadDocument(\StructType\UploadDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadMailingList
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format (refer to the CustomerAPI documentation for details on the CSV format requirements). You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken).
     * The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a problem occured. The
     * ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadMailingList $parameters
     * @return \StructType\UploadMailingListResponse|bool
     */
    public function UploadMailingList(\StructType\UploadMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadMailingListWithMapping
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format. You can also specify the ID of a custom mapping to successfully extract the addresses from your spreadsheet. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a
     * problem occured. The ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadMailingListWithMapping $parameters
     * @return \StructType\UploadMailingListWithMappingResponse|bool
     */
    public function UploadMailingListWithMapping(\StructType\UploadMailingListWithMapping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingListWithMapping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UploadMailingListWithMappingAndShare
     * Meta information extracted from the WSDL
     * - documentation: Use this method to upload a mailing list in CSV format. You can also specify the ID of a custom mapping to successfully extract the addresses from your spreadsheet. You must supply a valid LoginToken to use this method (use SignIn to
     * acquire a LoginToken). The Mailing Address Name you supply will be used to display your mailing list. The MailingListData parameter must contain your CSV data as a Base64-encoded byte array. This method returns True if successful or False if a
     * problem occured. The ReturnMessage provides an explanation in the event of a failure. The MailingListID parameter is populated with the ID of the new record.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadMailingListWithMappingAndShare $parameters
     * @return \StructType\UploadMailingListWithMappingAndShareResponse|bool
     */
    public function UploadMailingListWithMappingAndShare(\StructType\UploadMailingListWithMappingAndShare $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadMailingListWithMappingAndShare($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadConsolidatedPDF
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method upload a Consolidated PDF. The consolidated PDF will be splint into individual documents based on SplitOptions and then sent/uploaded as individual letters.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadConsolidatedPDF $parameters
     * @return \StructType\UploadConsolidatedPDFResponse|bool
     */
    public function UploadConsolidatedPDF(\StructType\UploadConsolidatedPDF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadConsolidatedPDF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UploadConsolidatedPDFResponse|\StructType\UploadDocumentResponse|\StructType\UploadMailingListResponse|\StructType\UploadMailingListWithMappingAndShareResponse|\StructType\UploadMailingListWithMappingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
