<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to edit an existing letter. The new ID will be returned and all references to the letter will be updated.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLetter $parameters
     * @return \StructType\UpdateLetterResponse|bool
     */
    public function UpdateLetter(\StructType\UpdateLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMailPackLetter
     * Meta information extracted from the WSDL
     * - documentation: Use this method to update a Mail Pack to refer to a different letter.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMailPackLetter $parameters
     * @return \StructType\UpdateMailPackLetterResponse|bool
     */
    public function UpdateMailPackLetter(\StructType\UpdateMailPackLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateMailPackLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMailPackTemplate
     * Meta information extracted from the WSDL
     * - documentation: Use this method to update a Mail Pack to refer to a different template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMailPackTemplate $parameters
     * @return \StructType\UpdateMailPackTemplateResponse|bool
     */
    public function UpdateMailPackTemplate(\StructType\UpdateMailPackTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateMailPackTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateLetterResponse|\StructType\UpdateMailPackLetterResponse|\StructType\UpdateMailPackTemplateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
