<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sign ServiceType
 * @subpackage Services
 */
class Sign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SignIn
     * Meta information extracted from the WSDL
     * - documentation: Use this method to sign in to the ViaPost User Webservices. Signing in is mandatory and must be done before any other service methods can be used. You must supply a valid Viapost Username and Password. Returns a LoginToken which must
     * be supplied as a parameter to the other methods. This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SignIn $parameters
     * @return \StructType\SignInResponse|bool
     */
    public function SignIn(\StructType\SignIn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SignIn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SignInResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
