<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendDriverMailingConfirmation
     * Meta information extracted from the WSDL
     * - documentation: Internal use only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendDriverMailingConfirmation $parameters
     * @return \StructType\SendDriverMailingConfirmationResponse|bool
     */
    public function SendDriverMailingConfirmation(\StructType\SendDriverMailingConfirmation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDriverMailingConfirmation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPack
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a previously saved Mail Pack.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMailPack $parameters
     * @return \StructType\SendMailPackResponse|bool
     */
    public function SendMailPack(\StructType\SendMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a previously saved Mail Pack to a Mailing list created from Find Nearest.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMailPackToFindNearest $parameters
     * @return \StructType\SendMailPackToFindNearestResponse|bool
     */
    public function SendMailPackToFindNearest(\StructType\SendMailPackToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToSingleAddress2
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Mail Pack a previously saved MailPack to a Single Address. This will require a Mail Pack ID and single address details. This method is used by the ViaPost Spooler software. SendMailPackToSingleAddress should
     * be used for any API integration.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMailPackToSingleAddress2 $parameters
     * @return \StructType\SendMailPackToSingleAddress2Response|bool
     */
    public function SendMailPackToSingleAddress2(\StructType\SendMailPackToSingleAddress2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToSingleAddress2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailPackToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Mail Pack a previously saved MailPack to a Single Address. This will require a Mail Pack ID and single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMailPackToSingleAddress $parameters
     * @return \StructType\SendMailPackToSingleAddressResponse|bool
     */
    public function SendMailPackToSingleAddress(\StructType\SendMailPackToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailPackToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailing
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Simple Mailing. A simple mailing consists of a previosly uploaded letter and an address list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendSimpleMailing $parameters
     * @return \StructType\SendSimpleMailingResponse|bool
     */
    public function SendSimpleMailing(\StructType\SendSimpleMailing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailingToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send a Simple Mailing to a Mailing list created from Find Nearest. A simple mailing consists of a previosly uploaded letter and address details for a Find Nearest search.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendSimpleMailingToFindNearest $parameters
     * @return \StructType\SendSimpleMailingToFindNearestResponse|bool
     */
    public function SendSimpleMailingToFindNearest(\StructType\SendSimpleMailingToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailingToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSimpleMailingToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to create and send a Simple Mailing to a Single Address. A letter in either PDF or Word XML (.xml) must be supplied with the single address details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendSimpleMailingToSingleAddress $parameters
     * @return \StructType\SendSimpleMailingToSingleAddressResponse|bool
     */
    public function SendSimpleMailingToSingleAddress(\StructType\SendSimpleMailingToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSimpleMailingToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcardToSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendPostcardToSingleAddress $parameters
     * @return \StructType\SendPostcardToSingleAddressResponse|bool
     */
    public function SendPostcardToSingleAddress(\StructType\SendPostcardToSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcardToSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcard
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendPostcard $parameters
     * @return \StructType\SendPostcardResponse|bool
     */
    public function SendPostcard(\StructType\SendPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPostcardToFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Use this method to send an existing postcard to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendPostcardToFindNearest $parameters
     * @return \StructType\SendPostcardToFindNearestResponse|bool
     */
    public function SendPostcardToFindNearest(\StructType\SendPostcardToFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendPostcardToFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendLetterWithStructuredAddress
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to send a letter using a structured address block (as returned by SearchAddress) and receive detailed information on the address validation if it fails (PafCode and ReturnMessage). You must supply a valid
     * LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendLetterWithStructuredAddress $parameters
     * @return \StructType\SendLetterWithStructuredAddressResponse|bool
     */
    public function SendLetterWithStructuredAddress(\StructType\SendLetterWithStructuredAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetterWithStructuredAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SendLetterWithStructuredAddressAndExceptions
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] This method is a specialisation of the old SendLetterWithStructuredAddress that allows users force an address i.e. it is not checked against the PAF database. There is additional cost for this option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendLetterWithStructuredAddressAndExceptions $parameters
     * @return \StructType\SendLetterWithStructuredAddressAndExceptionsResponse|bool
     */
    public function SendLetterWithStructuredAddressAndExceptions(\StructType\SendLetterWithStructuredAddressAndExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetterWithStructuredAddressAndExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendLetter
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Use this method to send a letter. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). This method returns True if successful or False if a problem occured. The ReturnMessage
     * provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendLetter $parameters
     * @return \StructType\SendLetterResponse|bool
     */
    public function SendLetter(\StructType\SendLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendDriverMailingConfirmationResponse|\StructType\SendLetterResponse|\StructType\SendLetterWithStructuredAddressAndExceptionsResponse|\StructType\SendLetterWithStructuredAddressResponse|\StructType\SendMailPackResponse|\StructType\SendMailPackToFindNearestResponse|\StructType\SendMailPackToSingleAddress2Response|\StructType\SendMailPackToSingleAddressResponse|\StructType\SendPostcardResponse|\StructType\SendPostcardToFindNearestResponse|\StructType\SendPostcardToSingleAddressResponse|\StructType\SendSimpleMailingResponse|\StructType\SendSimpleMailingToFindNearestResponse|\StructType\SendSimpleMailingToSingleAddressResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
