<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SearchAddress
     * Meta information extracted from the WSDL
     * - documentation: Passed an address to search for in InputAddress (can be partially complete), returns a list of postal addresses as well as descriptive text (ReturnMessage) and a code (PafCode) for the results of the search. You must supply a valid
     * LoginToken to use this method (use SignIn to acquire a LoginToken). If an address search fails the PafCode and ReturnMessage parameters will have more detail and the list of returned addresses will be empty.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchAddress $parameters
     * @return \StructType\SearchAddressResponse|bool
     */
    public function SearchAddress(\StructType\SearchAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SearchAddressResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
