<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retry ServiceType
 * @subpackage Services
 */
class Retry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetryLetter
     * Meta information extracted from the WSDL
     * - documentation: Retry sending a letter which couldn't previously be sent.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetryLetter $parameters
     * @return \StructType\RetryLetterResponse|bool
     */
    public function RetryLetter(\StructType\RetryLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetryLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetryLetterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
