<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Preview ServiceType
 * @subpackage Services
 */
class Preview extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PreviewLibraryPostcard
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the postcard which was uploaded via the portal or the CreatePostcard API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewLibraryPostcard $parameters
     * @return \StructType\PreviewLibraryPostcardResponse|bool
     */
    public function PreviewLibraryPostcard(\StructType\PreviewLibraryPostcard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryPostcard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryLetterhead
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the letterhead which was uploaded via the portal or the CreateLetterhead API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewLibraryLetterhead $parameters
     * @return \StructType\PreviewLibraryLetterheadResponse|bool
     */
    public function PreviewLibraryLetterhead(\StructType\PreviewLibraryLetterhead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryLetterhead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryAttachment
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the attachment which was uploaded via the portal or the CreateAttachment API method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewLibraryAttachment $parameters
     * @return \StructType\PreviewLibraryAttachmentResponse|bool
     */
    public function PreviewLibraryAttachment(\StructType\PreviewLibraryAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentSingleAddress
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a single address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewDocumentSingleAddress $parameters
     * @return \StructType\PreviewDocumentSingleAddressResponse|bool
     */
    public function PreviewDocumentSingleAddress(\StructType\PreviewDocumentSingleAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentSingleAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentMailingList
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a mailing list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewDocumentMailingList $parameters
     * @return \StructType\PreviewDocumentMailingListResponse|bool
     */
    public function PreviewDocumentMailingList(\StructType\PreviewDocumentMailingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewDocumentFindNearest
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that represents the finalized document to be sent to a mailing list created from a find nearest request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewDocumentFindNearest $parameters
     * @return \StructType\PreviewDocumentFindNearestResponse|bool
     */
    public function PreviewDocumentFindNearest(\StructType\PreviewDocumentFindNearest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewDocumentFindNearest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLetter
     * Meta information extracted from the WSDL
     * - documentation: [Deprecated] Gets a byte array that is the PDF letter with the stickered address. Only works for addresses with a valid postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewLetter $parameters
     * @return \StructType\PreviewLetterResponse|bool
     */
    public function PreviewLetter(\StructType\PreviewLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewLibraryLetter
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the letter which was uploaded via the portal or the CreateLetter API method. Letters uploaded via the UploadDocument or UploadConsolidatedPDF API methods are not supported.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewLibraryLetter $parameters
     * @return \StructType\PreviewLibraryLetterResponse|bool
     */
    public function PreviewLibraryLetter(\StructType\PreviewLibraryLetter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewLibraryLetter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewMailPack
     * Meta information extracted from the WSDL
     * - documentation: Gets a byte array that is the PDF Mail Pack with the stickered address. Only works for addresses with a valid postcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewMailPack $parameters
     * @return \StructType\PreviewMailPackResponse|bool
     */
    public function PreviewMailPack(\StructType\PreviewMailPack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PreviewMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PreviewDocumentFindNearestResponse|\StructType\PreviewDocumentMailingListResponse|\StructType\PreviewDocumentSingleAddressResponse|\StructType\PreviewLetterResponse|\StructType\PreviewLibraryAttachmentResponse|\StructType\PreviewLibraryLetterheadResponse|\StructType\PreviewLibraryLetterResponse|\StructType\PreviewLibraryPostcardResponse|\StructType\PreviewMailPackResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
