<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mail ServiceType
 * @subpackage Services
 */
class Mail extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MailMerge
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MailMerge $parameters
     * @return \StructType\MailMergeResponse|bool
     */
    public function MailMerge(\StructType\MailMerge $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMerge($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * MailMergeWithExceptionsAndConfirmationEmails
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. You can choose whether you want to send a confirmation email out for each letter. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MailMergeWithExceptionsAndConfirmationEmails $parameters
     * @return \StructType\MailMergeWithExceptionsAndConfirmationEmailsResponse|bool
     */
    public function MailMergeWithExceptionsAndConfirmationEmails(\StructType\MailMergeWithExceptionsAndConfirmationEmails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMergeWithExceptionsAndConfirmationEmails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MailMergeWithExceptions
     * Meta information extracted from the WSDL
     * - documentation: Use this method to perform a mail merge. You must supply a valid LoginToken to use this method (use SignIn to acquire a LoginToken). The Letter and MailingList you supply will be used to select the letter template and mailing list to
     * be used. This method returns True if successful or False if a problem occurred. The ReturnMessage provides an explanation in the event of a failure.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MailMergeWithExceptions $parameters
     * @return \StructType\MailMergeWithExceptionsResponse|bool
     */
    public function MailMergeWithExceptions(\StructType\MailMergeWithExceptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MailMergeWithExceptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MailMergeResponse|\StructType\MailMergeWithExceptionsAndConfirmationEmailsResponse|\StructType\MailMergeWithExceptionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
