<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IsFirstClassAvailable
     * Meta information extracted from the WSDL
     * - documentation: Determine if 1st class delivery support is available in addition to the standard 2nd class delivery support.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsFirstClassAvailable $parameters
     * @return \StructType\IsFirstClassAvailableResponse|bool
     */
    public function IsFirstClassAvailable(\StructType\IsFirstClassAvailable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsFirstClassAvailable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsValidLoginToken
     * Meta information extracted from the WSDL
     * - documentation: Checks whether the supplied login token is valid or not.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsValidLoginToken $parameters
     * @return \StructType\IsValidLoginTokenResponse|bool
     */
    public function IsValidLoginToken(\StructType\IsValidLoginToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsValidLoginToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IsFirstClassAvailableResponse|\StructType\IsValidLoginTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
